<?php
/**
 * The default template for displaying the full post with title above featured image
 * @package Simplified_Lite
*/
?>

<?php
while ( have_posts() ) : the_post(); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>


    <?php	if ( '' !== get_the_post_thumbnail() && esc_attr(get_theme_mod( 'simplified_lite_show_single_featured', 1 ) ) ) :  
	echo '<div class="featured-image">';		
		the_post_thumbnail( 'post-thumbnail', array( 'alt' => the_title_attribute( 'echo=0' ), 'class' => ''));		
	echo '</div>';			
	endif; 
	?>
    <header class="entry-header post-width">
        <?php	the_title( '<h1 class="entry-title">', '</h1>' );									
			if ( 'post' === get_post_type()) {
			echo '<ul class="entry-meta">';		
				simplified_lite_posted_on();
				simplified_lite_posted_by();	
				simplified_lite_categories();
				simplified_lite_comments_count();	
				if ( esc_attr(get_theme_mod( 'simplified_lite_show_edit_link', false ) ) ) :				
					simplified_lite_edit_link();
				endif;
			echo '</ul>';
		};
		?>
    </header>
    <div class="entry-content post-width">
        <?php	the_content();?>
    </div>
	
	<?php 
		if ( esc_attr(get_theme_mod( 'simplified_lite_show_entry_tags', true ) ) && has_tag() ) {
			echo '<p id="post-tags">', esc_html(simplified_lite_entry_tags()), '</p>';
		}
	?>
	
    <?php if ( get_the_author_meta( 'description' ) && esc_attr(get_theme_mod( 'simplified_lite_show_author_bio', true ) ) ) : ?>
    <div id="entry-footer" class="post-width">
        <?php get_template_part( 'author-bio' ); ?>
    </div>
    <?php endif; ?>

</article>

<div class="post-width">

    <?php 	// single post navigation
	if ( esc_attr(get_theme_mod( 'simplified_lite_show_post_nav', true )) ) :
		get_template_part( 'template-parts/navigation/nav', 'post' );
	endif;
?>

    <?php 
	// If comments are open or we have at least one comment, load up the comment template.
	if ( comments_open() || get_comments_number() ) :
		comments_template();
	endif;

endwhile; // End of the loop.
?>
</div>
