<?php
/**
 * Template file for blog headers
 * @package Simplified_Lite
 */

 $simplified_lite_blog_title = get_theme_mod( 'simplified_lite_blog_title');
 $simplified_lite_blog_intro = get_theme_mod( 'simplified_lite_blog_intro');
 
?>

<header id="page-header" class="col-lg-12">

    <?php if ( is_home() || is_front_page() ) : ?>
    <?php if( esc_attr(get_theme_mod( 'simplified_lite_show_blog_heading', false ) ) ) : ?>

    <h1 class="page-title">
        <?php echo esc_html( $simplified_lite_blog_title ); ?>
    </h1>
    <p id="blog-description" class="lead">
        <?php echo esc_html( $simplified_lite_blog_intro ); ?>
    </p>

    <?php endif; ?>
    <?php elseif (is_archive() ) : ?>

    <?php
			the_archive_title( '<h1 class="page-title">', '</h1>' );
			the_archive_description( '<div id="category-description" class="lead">', '</div>' );
		?>

    <?php else : ?>

    <h2 class="page-title screen-reader-text">
        <?php esc_html_e( 'Posts', 'simplified-lite' ); ?>
    </h2>

    <?php endif; ?>

</header>
<div class="w-100"></div>
