<?php
/**
 * Template file for the list blog content
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Simplified_Lite
 */
 $bloglayout = esc_attr(get_theme_mod( 'simplified_lite_blog_layout', 'blog1' ));
?>


<?php if ( have_posts() ) :
	/* Start the Loop */
	while ( have_posts() ) : the_post(); ?>


<?php if ( $bloglayout == 'blog3')  : ?>
<div class="row align-items-center">
    <?php else : ?>
    <div class="row">
        <?php endif; ?>

        <?php if ($bloglayout == 'blog4' || $bloglayout == 'blog5' ) : ?>
        <div class="col-lg-4">
            <?php else : ?>
            <div class="col-lg-5">
                <?php endif; ?>

                <?php if ( '' !== get_the_post_thumbnail() ) : ?>
                <div class="featured-image">
                    <?php if( is_sticky()  && esc_attr(get_theme_mod( 'simplified_lite_show_featured_tag', true ) ) ) : 
					echo '<div class="ribbon-wrapper-featured d-none d-sm-block"><div class="ribbon-featured">', esc_html_e('Featured', 'simplified-lite'), '</div></div>';
					endif; ?>

                    <a href="<?php echo esc_url( get_the_permalink() ); ?>">

                        <?php 
						if ( esc_attr(get_theme_mod( 'simplified_lite_list_sidebar_thumbnails', false )) ) :
						
							if ($bloglayout == 'blog4' || $bloglayout == 'blog5' ) :
							
								the_post_thumbnail( 'simplified-list-sidebar' );  
								
							elseif ($bloglayout == 'blog3' ) :
								the_post_thumbnail( 'simplified-list' ); 
						else :
							the_post_thumbnail( 'post-thumbnails' ); 
						endif;
						endif;						
						?>
                    </a>
                    <?php if( esc_attr(get_theme_mod( 'simplified_lite_show_featured_captions', true ) ) ) {			
					$get_description = get_post(get_post_thumbnail_id())->post_excerpt;
					  if(!empty($get_description) ) {
						  //If description is not empty show the div
					  echo '<div class="post-caption-container"><p class="post-caption">' . esc_html($get_description) . '</p></div>';
					  }
					  }
					?>
                </div>
	<?php else : ?>

	<?php if( is_sticky()  && esc_attr(get_theme_mod( 'simplified_lite_show_featured_tag', true ) ) ) :
		echo '<div class="featured-label-wrapper"><div class="featured-label">', esc_html_e('Featured', 'simplified-lite'), '</div></div>';
	endif; ?>
	
                <?php endif; ?>
            </div>

            <?php if ($bloglayout == 'blog4' || $bloglayout == 'blog5' ) : ?>
            <div class="col-lg-8">
                <?php else : ?>
                <div class="col-lg-7">
                    <?php endif; ?>
                    <div class="list-content">
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                            <header class="entry-header">

                                <?php // get the post title and posted date info
								the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );						
							if ( 'post' === get_post_type() ) {
								echo '<ul class="entry-meta">';
								
								if( esc_attr(get_theme_mod( 'simplified_lite_show_post_date', true ) ) ) :
									simplified_lite_posted_on();
								endif;	
								if( is_multi_author() && esc_attr(get_theme_mod( 'simplified_lite_show_post_author', true ) ) ) :	
									simplified_lite_posted_by();
								endif;	
								if( esc_attr(get_theme_mod( 'simplified_lite_show_post_comments', true ) ) ) :	
									simplified_lite_comments_count();
								endif;
									echo '</ul>';
							} 
												
						?>

                            </header>
                            <div class="entry-summary">
                                <?php	the_excerpt(); ?>
                            </div>
                        </article>
                    </div>
                </div>
            </div>

            <hr class="spacer">

            <?php
	endwhile;
		get_template_part( 'template-parts/navigation/nav', 'blog' );
	else :
		get_template_part( 'template-parts/post/content', 'none' );
	endif; ?>
