<?php
/**
 * Template file for the default blog content
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Simplified_Lite
 */
?>

<?php if ( have_posts() ) :
	/* Start the Loop */
	while ( have_posts() ) : the_post(); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <?php if ( '' !== get_the_post_thumbnail() ) : ?>
    <div class="featured-image">
        <?php if( is_sticky()  && esc_attr(get_theme_mod( 'simplified_lite_show_featured_tag', true ) ) ) : 
					echo '<div class="ribbon-wrapper-featured d-none d-sm-block"><div class="ribbon-featured">', esc_html_e('Featured', 'simplified-lite'), '</div></div>';
					endif; ?>

        <a href="<?php echo esc_url( get_the_permalink() ); ?>">
            <?php 
						if ( esc_attr(get_theme_mod( 'simplified_lite_default_thumbnails', false )) ) :
							the_post_thumbnail( 'simplified-default' );  
						else :
							the_post_thumbnail( 'post-thumbnails' ); 
						endif;				
						?>
        </a>
        <?php if( esc_attr(get_theme_mod( 'simplified_lite_show_featured_captions', true ) ) ) {			
					$get_description = get_post(get_post_thumbnail_id())->post_excerpt;
					  if(!empty($get_description) ) {
						  //If description is not empty show the div
					  echo '<div class="post-caption-container"><p class="post-caption">' . esc_html($get_description) . '</p></div>';
					  }
					  }
					?>
    </div>	
	
	<?php else : ?>
	
	<?php if( is_sticky()  && esc_attr(get_theme_mod( 'simplified_lite_show_featured_tag', true ) ) ) :
		echo '<div class="featured-label-wrapper"><div class="featured-label">', esc_html_e('Featured', 'simplified-lite'), '</div></div>';
	endif; ?>
	
    <?php endif; ?>

    <header class="entry-header">

        <?php // get the post meta information - each one can be disabled.
					if ( 'post' === get_post_type() ) {
						echo '<ul class="entry-meta">';
						
						if( is_multi_author() && esc_attr(get_theme_mod( 'simplified_lite_show_post_author', true ) ) ) :	
							simplified_lite_posted_by();
						endif;	
						if( esc_attr(get_theme_mod( 'simplified_lite_show_post_date', true ) ) ) :
							simplified_lite_posted_on();
						endif;	

						if( esc_attr(get_theme_mod( 'simplified_lite_show_post_comments', true ) ) ) :	
							simplified_lite_comments_count();
						endif;	
							echo '</ul>';
					} 							
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );							
			
				?>

    </header>



    <div class="entry-summary">
        <?php
				if ( esc_attr(get_theme_mod( 'simplified_lite_use_excerpt', false )) ) :
					the_excerpt();
				else :
				
					the_content( sprintf(
					/* translators: %s: Name of current post */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'simplified-lite' ),
						get_the_title()
					) );
					
					get_template_part( 'template-parts/navigation/nav', 'paged' );
					
					endif;
				?>
    </div>

</article>
<?php
	endwhile;
		get_template_part( 'template-parts/navigation/nav', 'blog' );
	else :
		get_template_part( 'template-parts/post/content', 'none' );
	endif; ?>
