<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Simplified_Lite
 */

$singlelayout = get_theme_mod( 'simplified_lite_single_layout', 'single1' ); 
get_header(); 

 $simplified_lite_blog_title = get_theme_mod( 'simplified_lite_blog_title');
 $simplified_lite_blog_intro = get_theme_mod( 'simplified_lite_blog_intro');
  
?>

<?php if( esc_attr(get_theme_mod( 'simplified_lite_show_single_blog_title_group', false ) ) ) : ?>
<header id="page-header" class="col-lg-12">
    <h1 class="page-title">
        <?php echo esc_html( $simplified_lite_blog_title ); ?>
    </h1>
    <p id="blog-description" class="lead">
        <?php echo esc_html( $simplified_lite_blog_intro ); ?>
    </p>
</header>
<div class="w-100"></div>
<?php endif; ?>


<?php // single with featured image above title
	if ( $singlelayout == 'single2')  : ?>

<div id="primary" class="content-area col-lg-8 order-lg-2">
    <main id="main" class="site-main <?php echo esc_attr($singlelayout); ?>">
        <?php get_template_part( 'template-parts/post/content', 'single' ); ?>
    </main>
</div>
<div class="col-lg-4 order-3 order-lg-1">
    <?php get_sidebar(); ?>
</div>

<?php // single right sidebar and featured image below title
	else : ?>

<div id="primary" class="content-area col-lg-8">
    <main id="main" class="site-main <?php echo esc_attr($singlelayout); ?>">
        <?php get_template_part( 'template-parts/post/content', 'single' ); ?>
    </main>
</div>

<div class="col-lg-4">
    <?php get_sidebar(); ?>
</div>

<?php endif; ?>

<?php
get_footer();
