<?php
/**
 * Template for displaying search forms
 * @package Simplified_Lite
 */
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    <label>
        <span class="screen-reader-text">
            <?php echo esc_html_x( 'Search for:', 'label', 'simplified-lite' ); ?></span>
        <input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'simplified-lite' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
    </label>
    <button type="submit" class="search-submit"><span class="screen-reader-text">
            <?php echo esc_html_x( 'Search', 'submit button', 'simplified-lite' ); ?></span><span class="icon-search"></span></button>
</form>
