<?php
/**
 * The main template file
 * This is the most generic template file in a WordPress theme and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query. E.g., it puts together the home page when no home.php file exists.
 * @package Simplified_Lite
 */

$bloglayout = esc_attr(get_theme_mod( 'simplified_lite_blog_layout', 'blog1' ));
 
get_header();
?>

<?php // for our archive headers and custom blog intro group
get_template_part( 'template-parts/page-headers' ); ?>


<?php // list blog with left sidebar
if ( $bloglayout == 'blog5')  : ?>
<?php get_template_part( 'template-parts/sidebars/sidebar', 'breadcrumbs' ); ?>
	<div id="primary" class="content-area col-lg-8 order-lg-2">
		<main id="main" class="site-main <?php echo esc_attr( $bloglayout ); ?>">
		<?php get_template_part( 'template-parts/layouts/blog', 'list' ); ?>
		</main>
	</div>
	<div class="col-lg-4 order-3 order-lg-1">
		<?php get_sidebar(); ?>       
	</div>	
	
<?php // list blog with right sidebar
elseif ( $bloglayout == 'blog4')  : ?>
<?php get_template_part( 'template-parts/sidebars/sidebar', 'breadcrumbs' ); ?>
	<div id="primary" class="content-area col-lg-8">
		<main id="main" class="site-main <?php echo esc_attr( $bloglayout ); ?>">
		<?php get_template_part( 'template-parts/layouts/blog', 'list' ); ?>
		</main>
	</div>
	<div class="col-lg-4">
	<?php get_sidebar(); ?>
	</div>

<?php // standard blog left sidebar
elseif ( $bloglayout == 'blog2')  : ?>
<?php get_template_part( 'template-parts/sidebars/sidebar', 'breadcrumbs' ); ?>
	<div id="primary" class="content-area col-lg-8 order-lg-2">
		<main id="main" class="site-main <?php echo esc_attr( $bloglayout ); ?>">
		<?php get_template_part( 'template-parts/layouts/blog', 'default' ); ?>
		</main>
	</div>
	<div class="col-lg-4 order-3 order-lg-1">
		<?php get_sidebar(); ?>       
	</div>		
	
<?php // standard blog right sidebar
else : ?>
<?php get_template_part( 'template-parts/sidebars/sidebar', 'breadcrumbs' ); ?>
	<div id="primary" class="content-area col-lg-8">
		<main id="main" class="site-main <?php echo esc_attr( $bloglayout ); ?>">
		<?php get_template_part( 'template-parts/layouts/blog', 'default' ); ?>
		</main>
		
	</div>
	<div class="col-lg-4">
	<?php get_sidebar(); ?>
	</div>
	
<?php endif; ?>


<?php
get_footer();