<?php
/**
 * Custom template tags for this theme
 * Eventually, some of the functionality here could be replaced by core features.
 * @package Simplified_Lite
 */
 
	
// Prints HTML with meta information for the current post-date/time.
if ( ! function_exists( 'simplified_lite_posted_on' ) ) :
	function simplified_lite_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}
		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);
		$posted_on = sprintf(
			/* translators: %s: post date. */
			//esc_html_x( 'Posted %s', 'post date', 'simplified-lite' ),
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
		);
		echo '<li class="posted-on">' . $posted_on . '</li>'; // WPCS: XSS OK.
	}
endif;

// Prints HTML with meta information for the current author.
if ( ! function_exists( 'simplified_lite_posted_by' ) ) :
	function simplified_lite_posted_by() {
		$byline = sprintf(
			/* translators: %s: post author. */
			//esc_html_x( 'by %s', 'post author', 'simplified-lite' ),
			'<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
		);
		echo '<li class="byline"> ' . $byline . '</li>'; // WPCS: XSS OK.
	}
endif;

// Add categories to the post meta info
if ( ! function_exists( 'simplified_lite_categories' ) ) :
function simplified_lite_categories() {
		
		$categories_list = get_the_category_list( esc_html__( ', ', 'simplified-lite' ) );
		if ( $categories_list ) {
			/* translators: 1: list of categories. */
			printf( '<li class="cat-links">' . esc_html__( 'In %1$s', 'simplified-lite' ) . '</li>', $categories_list ); // WPCS: XSS OK.
		}
	}
endif;

if ( ! function_exists( 'simplified_lite_comments_count' ) ) :
	function simplified_lite_comments_count() {
		// Add the comments link to the post meta info
		if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<li class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'simplified-lite' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</li>';
		}
}

endif;



if ( ! function_exists( 'simplified_lite_entry_tags' ) ) :

	//Prints HTML with meta information for the tags
	function simplified_lite_entry_tags() {
		
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {			
			// Get tag list
			if(get_the_tag_list()) {
				//echo '<p id="tag-list-title">' . esc_html__( 'Posts Tagged with&hellip;', 'simplified-lite' ) . '</p>';
				
				echo wp_kses_post(get_the_tag_list( sprintf( '<p class="tag-list">%s ', __( 'Posts Tagged with&hellip;', 'simplified-lite' ) ), ', ', '</p>' ) );
			}
		}	
	}
endif;

	/**
	 * Displays an optional post thumbnail.
	 * Wraps the post thumbnail in an anchor element on index views, or a div element when on single views.
	 */
if ( ! function_exists( 'simplified_lite_post_thumbnail' ) ) :

	function simplified_lite_post_thumbnail() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ) :
			?>

<div class="featured-image">
    <?php the_post_thumbnail(); ?>
</div><!-- .post-thumbnail -->

<?php else : ?>

<a class="featured-image" href="<?php echo esc_url( get_the_permalink() ); ?>" aria-hidden="true">
    <?php
			the_post_thumbnail( 'featured-image', array(
				'alt' => the_title_attribute( array(
					'echo' => false,
				) ),
			) );
			?>
</a>

<?php
		endif; // End is_singular().
	}
endif;

// Edit link function
if ( ! function_exists( 'simplified_lite_edit_link' ) ) :
	function simplified_lite_edit_link() {
		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'simplified-lite' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<li class="edit-link">',
			'</li>'
		);
	}
endif;
