<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 * @package Simplified_Lite
 */

/**
 * Adds custom classes to the array of body classes.
 * @param array $classes Classes for the body element.
 * @return array
 */
function simplified_lite_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
		
		if ( is_page_template( 'templates/full-width.php' ) ) {
			$classes[] = 'no-sidebar';				
		} else {
			$classes[] = 'sidebar';
		}
	
	return $classes;
}
add_filter( 'body_class', 'simplified_lite_body_classes' );

/**
 * Add CSS class to image navigation links.
 *
 * @wp-hook previous_image_link
 * @wp-hook next_image_link
 * @param   string $link Complete markup
 * @return  string
 */
add_filter( 'previous_image_link', 'simplified_lite_img_link_class' );
add_filter( 'next_image_link',     'simplified_lite_img_link_class' );

function simplified_lite_img_link_class( $link )
{
    $class = 'next_image_link' === current_filter() ? 'button' : 'button';
    return str_replace( '<a ', "<a class='$class'", $link );
}


/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function simplified_lite_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'simplified_lite_pingback_header' );


//	Move the read more link outside of the post summary paragraph	
add_filter( 'the_content_more_link', 'simplified_lite_move_more_link' );
	function simplified_lite_move_more_link() {
	return '<p class="more-link-wrapper"><a class="readmore" href="'. esc_url(get_permalink()) . '">' . esc_html__( 'Read More', 'simplified-lite' ) . '</a></p>';
}
	
// Replaces the excerpt "Read More" text by a link
function simplified_lite_excerpt_more($more) {
       global $post;
	return '&hellip;<p><a class="excerpt-readmore" href="'. esc_url(get_permalink($post->ID)) . '">' . esc_html__( 'Read More', 'simplified-lite' ) . '</a></p>';
}
add_filter('excerpt_more', 'simplified_lite_excerpt_more');
	
	
// Custom excerpt size
function simplified_lite_custom_excerpt_length( $length ) { 
	$simplified_lite_excerpt_size = esc_attr(get_theme_mod( 'simplified_lite_excerpt_size', '35' ));
	if ( is_admin() ) :
		return 55;		
	else: 	
		return $simplified_lite_excerpt_size;
	endif;
	}
add_filter( 'excerpt_length', 'simplified_lite_custom_excerpt_length', 999 );
