<?php
/**
 * Add inline styles to the head area
 * @package Simplified_Lite
*/
 
 // Dynamic styles
function simplified_lite_inline_styles($custom) {
	
// BEGIN CUSTOM CSS	
	
// body font family
if( get_theme_mod( 'simplified_lite_body_font_family' ) ) :
		$simplified_lite_body_font_family = get_theme_mod( 'simplified_lite_body_font_family' );	
		$custom .= "html, body { font-family: " . esc_attr($simplified_lite_body_font_family) . "; }"."\n";		
	endif;
	
// heading font family	
	if( get_theme_mod( 'simplified_lite_heading_font_family' ) ) :
		$simplified_lite_heading_font_family = get_theme_mod('simplified_lite_heading_font_family');		
		$custom .= "h1, h2, h3, h4, h5, h6, .entry-title a, #site-title { font-family: " . esc_attr($simplified_lite_heading_font_family) . "; }	"."\n";	
	endif;
	
// content
	$simplified_lite_top_bar = get_theme_mod('simplified_lite_top_bar', '#bb7514' );
	$simplified_lite_sitetitle = get_theme_mod('simplified_lite_sitetitle', '#000' );
	$simplified_lite_site_tagline = get_theme_mod('simplified_lite_site_tagline', '#868686' );
	$simplified_lite_page_content_bg = get_theme_mod('simplified_lite_page_content_bg', '#fff' );
	$simplified_lite_body_text = get_theme_mod('simplified_lite_body_text', '#686868' );
	$simplified_lite_breadcrumbs_text = get_theme_mod('simplified_lite_breadcrumbs_text', '#8e8e8e' );
	$simplified_lite_headings = get_theme_mod('simplified_lite_headings', '#000' );
	$simplified_lite_meta_hover = get_theme_mod('simplified_lite_meta_hover', '#bb7514' );
	$simplified_lite_links = get_theme_mod('simplified_lite_links', '#bb7514' );
	$simplified_lite_visited_links = get_theme_mod('simplified_lite_visited_links', '#bb7514' );
	$simplified_lite_hover_links = get_theme_mod('simplified_lite_hover_links', '#bb7514' );
	$simplified_lite_featured_bg = get_theme_mod('simplified_lite_featured_bg', '#018aaa' );
	$simplified_lite_featured_text = get_theme_mod('simplified_lite_featured_text', '#fff' );
	$simplified_lite_tag_hover_bg = get_theme_mod('simplified_lite_tag_hover_bg', '#bb7514' );
	$simplified_lite_tag_hover_text = get_theme_mod('simplified_lite_tag_hover_text', '#fff' );
	$simplified_lite_about_social_bg = get_theme_mod('simplified_lite_about_social_bg', '#018aaa' );
	$simplified_lite_about_social_icon = get_theme_mod('simplified_lite_about_social_icon', '#fff' );
	$simplified_lite_about_social_hover_bg = get_theme_mod('simplified_lite_about_social_hover_bg', '#bb7514' );
	$simplified_lite_about_social_hover_icon = get_theme_mod('simplified_lite_about_social_hover_icon', '#fff' );
	$simplified_lite_footer_bg = get_theme_mod('simplified_lite_footer_bg', '#1a1a1a' );
	$simplified_lite_footer_text = get_theme_mod( 'simplified_lite_footer_text', '#d8d8d8' );
$simplified_lite_footer_link_hover = get_theme_mod( 'simplified_lite_footer_link_hover', '#d298b4' );



	$custom .= "body {color: " . esc_attr($simplified_lite_body_text) . "; }	
	#page, #masthead,#site-footer { border-color: " . esc_attr($simplified_lite_top_bar) . "; }	
	#site-title a, #site-title a:visited { color: " . esc_attr($simplified_lite_sitetitle) . "; }
	#site-description { color: " . esc_attr($simplified_lite_site_tagline) . "; }
	#page, #nav-wrapper { background-color: " . esc_attr($simplified_lite_page_content_bg) . "; }
	#breadcrumbs-sidebar, #breadcrumbs-sidebar a, #breadcrumbs-sidebar a:visited {color: " . esc_attr($simplified_lite_breadcrumbs_text) . ";}
	h1, h2, h3, h4, h5, h6, .entry-title a, .entry-title a:visited {color: " . esc_attr($simplified_lite_headings) . ";}
	.entry-meta a:focus,.entry-meta a:hover, #breadcrumbs-sidebar a, aside a:hover {color: " . esc_attr($simplified_lite_meta_hover) . ";}
	a {color: " . esc_attr($simplified_lite_links) . ";}
	a:visited {color: " . esc_attr($simplified_lite_visited_links) . ";}
	a:hover, a:focus, a:active {color: " . esc_attr($simplified_lite_hover_links) . ";}
	.ribbon-featured, .featured-label {background-color: " . esc_attr($simplified_lite_featured_bg) . "; color: " . esc_attr($simplified_lite_featured_text) . ";}
	.tag-cloud-link:hover {background-color: " . esc_attr($simplified_lite_tag_hover_bg) . "; border-color: " . esc_attr($simplified_lite_tag_hover_bg) . ";color: " . esc_attr($simplified_lite_tag_hover_text) . ";}
	.about-icon, .about-icon:visited {background-color: " . esc_attr($simplified_lite_about_social_bg) . "; color: " . esc_attr($simplified_lite_about_social_icon) . ";}
	.about-icon:hover {background-color: " . esc_attr($simplified_lite_about_social_hover_bg) . "; color: " . esc_attr($simplified_lite_about_social_hover_icon) . ";}
	#site-footer {background-color: " . esc_attr($simplified_lite_footer_bg) . ";}
.site-info, .site-info a, .site-info a:visited, #footer-sidebar .widget-title  {color:" . esc_attr($simplified_lite_footer_text) . ";}
	.site-info a:focus, .site-info a:hover {color:" . esc_attr($simplified_lite_footer_link_hover) . ";}	
	"."\n";
	
// navigation
	$simplified_lite_mobile_toggle_button = get_theme_mod( 'simplified_lite_mobile_toggle_button', '#bb7514' );	
	$simplified_lite_mobile_toggle_label = get_theme_mod( 'simplified_lite_mobile_toggle_label', '#fff' );
	$simplified_lite_mobile_toggle_button_on = get_theme_mod( 'simplified_lite_mobile_toggle_button_on', '#0f0f0f' );
	$simplified_lite_mobile_toggle_label_on = get_theme_mod( 'simplified_lite_mobile_toggle_label_on', '#fff' );
	$simplified_lite_mobile_menu_lines = get_theme_mod( 'simplified_lite_mobile_menu_lines', '#d1d1d1' );	
	$simplified_lite_menu_topbottom_lines = get_theme_mod( 'simplified_lite_menu_topbottom_lines', '#afafaf' );
	$simplified_lite_menu_links = get_theme_mod( 'simplified_lite_menu_links', '#000' );
	$simplified_lite_menu_hover_links = get_theme_mod( 'simplified_lite_menu_hover_links', '#bb7514' );
	$simplified_lite_menu_active_link = get_theme_mod( 'simplified_lite_menu_active_link', '#bb7514' );
	$simplified_lite_submenu_dropdown_arrow_hover = get_theme_mod( 'simplified_lite_submenu_dropdown_arrow_hover', '#bb7514' );	
	$simplified_lite_submenu_top_border = get_theme_mod( 'simplified_lite_submenu_top_border', '#bb7514' );
	$simplified_lite_submenu_bg_hover = get_theme_mod( 'simplified_lite_submenu_bg_hover', '#bb7514' );	
	$simplified_lite_submenu_link_hover = get_theme_mod( 'simplified_lite_submenu_link_hover', '#fff' );		
	$simplified_lite_single_nav_bg = get_theme_mod( 'simplified_lite_single_nav_bg', '#1a1a1a' );
	$simplified_lite_single_nav_text = get_theme_mod( 'simplified_lite_single_nav_text', '#fff' );	
	$custom .= ".menu-toggle {background-color:" . esc_attr($simplified_lite_mobile_toggle_button) . "; border-color:" . esc_attr($simplified_lite_mobile_toggle_button) . "; color:" . esc_attr($simplified_lite_mobile_toggle_label) . ";}	
	.menu-toggle.toggled-on, .menu-toggle.toggled-on:hover, .menu-toggle.toggled-on:focus {background-color:" . esc_attr($simplified_lite_mobile_toggle_button_on) . "; border-color:" . esc_attr($simplified_lite_mobile_toggle_button_on) . "; color:" . esc_attr($simplified_lite_mobile_toggle_label_on) . ";}	
	.toggled-on .main-navigation li {border-color:" . esc_attr($simplified_lite_mobile_menu_lines) . ";}	
	#nav-wrapper {border-color:" . esc_attr($simplified_lite_menu_topbottom_lines) . ";}
	.main-navigation a, .dropdown-toggle {color:" . esc_attr($simplified_lite_menu_links) . ";}
	.main-navigation li:hover > a,	.main-navigation li.focus > a {color:" . esc_attr($simplified_lite_menu_hover_links) . ";}	
	.main-navigation .current-menu-item > a, .main-navigation .current-menu-ancestor > a,.widget_nav_menu .current-menu-item a, .widget_pages .current-menu-item a {color:" . esc_attr($simplified_lite_menu_active_link) . ";}	
	.dropdown-toggle:hover,.dropdown-toggle:focus {color:" . esc_attr($simplified_lite_submenu_dropdown_arrow_hover) . ";}	
	@media (min-width: 992px) {.main-navigation ul ul {border-color:" . esc_attr($simplified_lite_submenu_top_border) . ";}
	.main-navigation ul ul a:hover {background-color:" . esc_attr($simplified_lite_submenu_bg_hover) . "; color:" . esc_attr($simplified_lite_submenu_link_hover) . ";} }

	.single .nav-links {background-color:" . esc_attr($simplified_lite_single_nav_bg) . "; }
	.single .nav-links a,.single .nav-links a:visited {color:" . esc_attr($simplified_lite_single_nav_text) . ";}
	"."\n";	

// forms
	$simplified_lite_button = get_theme_mod( 'simplified_lite_button', '#1a1a1a' );	
	$simplified_lite_button_label = get_theme_mod( 'simplified_lite_button_label', '#fff' );
	$simplified_lite_button_hover = get_theme_mod( 'simplified_lite_button_hover', '#bb7514' );	
	$simplified_lite_button_label_hover = get_theme_mod( 'simplified_lite_button_label_hover', '#fff' );	
	$custom .= "button, .button:visited,button[disabled]:hover, button[disabled]:focus, input[type=button], input[type=button][disabled]:hover, input[type=button][disabled]:focus, input[type=reset], input[type=reset][disabled]:hover, input[type=reset][disabled]:focus, input[type=submit], input[type=submit][disabled]:hover, input[type=submit][disabled]:focus  {background-color: " . esc_attr($simplified_lite_button) . "; color: " . esc_attr($simplified_lite_button_label) . ";}	
	.button:hover,button:hover, button:focus, input[type=button]:hover, input[type=button]:focus, input[type=reset]:hover, input[type=reset]:focus, input[type=submit]:hover, input[type=submit]:focus  {background-color: " . esc_attr($simplified_lite_button_hover) . "; color: " . esc_attr($simplified_lite_button_label_hover) . ";}	
	"."\n";

// widgets
	$simplified_lite_widget_title_bg = get_theme_mod( 'simplified_lite_widget_title_bg', '#1a1a1a' );	
	$simplified_lite_widget_title = get_theme_mod( 'simplified_lite_widget_title', '#fff' );	
	$simplified_lite_bottom_sidebar_bg = get_theme_mod('simplified_lite_bottom_sidebar_bg', '#bb7514' );	
	$simplified_lite_bottom_sidebar_text = get_theme_mod('simplified_lite_bottom_sidebar_text', '#fff' );
	$custom .= "#bottom-sidebar {background-color: " . esc_attr($simplified_lite_bottom_sidebar_bg) . "; }
	#bottom-sidebar, #bottom-sidebar .widget-title, #bottom-sidebar a, #bottom-sidebar a:visited {color: " . esc_attr($simplified_lite_bottom_sidebar_text) . ";}
	#left-sidebar .widget-title, #right-sidebar .widget-title {background-color:" . esc_attr($simplified_lite_widget_title_bg) . "; color:" . esc_attr($simplified_lite_widget_title) . ";} 	
	"."\n";

 if (  is_front_page() && false == esc_attr(get_theme_mod( 'simplified_lite_show_fp_title', true ) ) ) :
	$custom .= ".home .entry-title {display: none;}
.home #page-header {margin-bottom: 1rem;}	"."\n";
endif;
	
// shadow under widget titles	
if( esc_attr(get_theme_mod( 'simplified_lite_show_widget_title_shadow', true ) ) ) :
	$simplified_lite_show_widget_title_shadow = get_theme_mod( 'simplified_lite_show_widget_title_shadow', true );
	$custom .= "#left-sidebar .widget-title, #right-sidebar .widget-title { box-shadow: 0px 18px 18px -15px rgba(0, 0, 0, 0.5); } "."\n";
endif;
	
// shadow under featured and banner images
if( esc_attr(get_theme_mod( 'simplified_lite_show_shadow', true ) ) ) :
	$simplified_lite_show_shadow = get_theme_mod( 'simplified_lite_show_shadow', true );	
	$custom .= "#banner, .featured-image, .image-wrapper, .about-image, .wp-block-image.alignfull img, .wp-block-image.alignwide img,.wp-block-cover { box-shadow: 0px 30px 34px -25px rgba(0, 0, 0, 0.5);}
.recent-featured-image {box-shadow: 0px 22px 10px -20px rgba(0, 0, 0, 0.5);}
	"."\n";
endif;

// dropcap		
if( esc_attr(get_theme_mod( 'simplified_lite_show_dropcap', false ) ) ) :
	$simplified_lite_dropcap_colour = get_theme_mod( 'simplified_lite_dropcap_colour', '#333' );		
	$custom .= ".single-post .entry-content > p:first-of-type::first-letter {
	font-weight: 700;
	font-style: normal;
	font-family: \"Times New Roman\", Times, serif;
	font-size: 5.5rem;
	font-weight: normal;
	line-height: 0.8;
	float: left;
	margin: 4px 0 0;
	padding-right: 1rem;
	text-transform: uppercase;
	}
	.single-post .entry-content h2 ~ p:first-of-type::first-letter {
		font-size: initial;	
		font-weight: initial;	
		line-height: initial; 
		float: initial;	
		margin-bottom: initial;	
		padding-right: initial;	
		text-transform: initial;
	}	
	.single-post .entry-content > p:first-of-type::first-letter {color:" . esc_attr($simplified_lite_dropcap_colour) . "}"."\n";
endif;

// Dropcap
	$simplified_lite_dropcap_colour = esc_attr(get_theme_mod( 'simplified_lite_dropcap_colour', '#333' ) );			
	$custom .="p.has-drop-cap:not(:focus):first-letter { color: $simplified_lite_dropcap_colour;	} ";
	
 
// END CUSTOM CSS
//Output all the styles
	wp_add_inline_style( 'simplified-style', $custom );	
}
add_action( 'wp_enqueue_scripts', 'simplified_lite_inline_styles' );
