<?php
/**
 * Blog Writer Pro Theme Customizer
 * @package Simplified_Lite
 */

 /**
 * Control type.
 * @access public
 * @var string
 */
 if ( ! class_exists( 'Simplified_Customize_Static_Text_Control' ) ){
	if ( ! class_exists( 'WP_Customize_Control' ) )
    return NULL;
		class Simplified_Customize_Static_Text_Control extends WP_Customize_Control {
		public $type = 'static-text';
		public function esc_html__construct( $manager, $id, $args = array() ) {
			parent::__construct( $manager, $id, $args );
		}
		protected function render_content() {
			if ( ! empty( $this->label ) ) :
				?><span class="Blog-Writer-customize-control-title"><?php echo esc_html( $this->label ); ?></span><?php
			endif;
			if ( ! empty( $this->description ) ) :
				?><div class="Blog-Writer-description Blog-Writer-customize-control-description"><?php

				if ( is_array( $this->description ) ) {
					$sanitized_descriptions = array_map( 'wp_kses_post', $this->description );
					echo '<p>' . implode( '</p><p>', $sanitized_descriptions ) . '</p>';					
				} else {
					echo wp_kses_post( $this->description );
				}
				?>
							
			<h1><?php esc_html_e('Simplified Pro', 'simplified-lite') ?></h1>
			
			<p><?php esc_html_e('If you decide to upgrade to the pro version of this theme, use this discount code on checkout.','simplified-lite'); ?></p>	
			<div id="promotion-header"><p class="main-title"><?php esc_html_e('Upgrade to Pro (Save 5%)', 'simplified-lite') ?><br><?php esc_html_e('Use Code:', 'simplified-lite') ?> <strong><?php esc_html_e('SAVEFIVE', 'simplified-lite') ?></strong></p>
			<p><a href="https://www.bloggingthemestyles.com/wordpress-themes/simplified-pro/" target="_blank" class="button button-primary"><?php esc_html_e('Get the Pro - Save 5%', 'simplified-lite') ?></a></p></div>
			
			<p style="font-weight: 700;"><?php esc_html_e('Pro Features:', 'simplified-lite') ?></p>
			<ul>
			<li><?php esc_html_e('&bull; Gutenberg Editor Styles', 'simplified-lite')?></li>
			<li><?php esc_html_e('&bull; Classic Editor Styles', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; 14 Blog Layouts', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; 4 Full Post Layouts', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; 12 Sidebar Positions', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Thumbnail Creation for the Blogs', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Recent Post Widget w/thumbnails', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; About Me Widget', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Social Links Widget', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Related Posts w/Thumbnails', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Customizable Read More Button', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Font Extras', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Custom Styled Archive Titles', 'simplified-lite')?></li>
				<li><?php esc_html_e('&bull; Page Builder Ready', 'simplified-lite')?></li>
			</ul>
			
			<p><a class="button" href="<?php echo esc_url('https://www.bloggingthemestyles.com/wordpress-themes/simplified-pro'); ?>" target="_blank"><?php esc_html_e( 'Get the Pro', 'simplified-lite' ); ?></a></p>				
			<?php
			endif;
		}
	}
}

// Add postMessage support for site title and description for the Theme Customizer.
function simplified_lite_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_control('background_color')->label = esc_html__( 'Page Background Colour', 'simplified-lite' );
	

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '#site-title a',
			'render_callback' => 'simplified_lite_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '#site-description',
			'render_callback' => 'simplified_lite_customize_partial_blogdescription',
		) );
	}
	
// Begin theme settings
   // SECTION - SIMPLIFIED UPGRADE
    $wp_customize->add_section( 'simplified_lite_upgrade', array(
        'title'       => esc_html__( 'Upgrade to Pro', 'simplified-lite' ),
        'priority'    => 0
    ) );
	
		$wp_customize->add_setting( 'simplified_lite_upgrade', array(
			'default' => '',
			'sanitize_callback' => '__return_false'
		) );
		
		$wp_customize->add_control( new Simplified_Customize_Static_Text_Control( $wp_customize, 'simplified_lite_upgrade', array(
			'label'	=> esc_html__('Get The Pro Version:','simplified-lite'),
			'section'	=> 'simplified_lite_upgrade',
			'description' => array('')
		) ) );	
		
// ADD TO SITE IDENTITY	
	// Show site title
	$wp_customize->add_setting( 'simplified_lite_show_site_title',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_site_title', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Site Title', 'simplified-lite' ),
		'section'  => 'title_tagline',
	) );		
		
	// Show site description
	$wp_customize->add_setting( 'simplified_lite_show_site_desc',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_site_desc', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Site Description', 'simplified-lite' ),
		'section'  => 'title_tagline',
	) );		

// Site Title Colour
 	$wp_customize->add_setting( 'simplified_lite_sitetitle', array(
		'default'        => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_sitetitle', array(
		'label'   => esc_html__( 'Site Title Colour', 'simplified-lite' ),
		'section' => 'title_tagline',
		'settings'   => 'simplified_lite_sitetitle',
	) ) );
	
// Site Title tagline
 	$wp_customize->add_setting( 'simplified_lite_site_tagline', array(
		'default'        => '#989898',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_site_tagline', array(
		'label'   => esc_html__( 'Site Tagline Colour', 'simplified-lite' ),
		'section' => 'title_tagline',
		'settings'   => 'simplified_lite_site_tagline',
	) ) );	
	
    // header size
    $wp_customize->add_setting( 'simplified_lite_header_size',  array(
            'sanitize_callback' => 'absint',
            'default'           => '28',
        ) );
    $wp_customize->add_control( 'simplified_lite_header_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline',
        'label'       => esc_html__('Header Size', 'simplified-lite'),
		'description' => esc_html__('You can change the height of your site header in increments of 1px. The default is 28, but you can go as high as 50.', 'simplified-lite'), 
        'input_attrs' => array(
            'min'   => 1,
            'max'   => 50,
            'step'  => 1,
        ),
    ) );	
	
// SECTION - THEME OPTIONS
	$wp_customize->add_section( 'simplified_lite_theme_options', array(
		'title'    => __( 'Theme Options', 'simplified-lite' ),
		'priority' => 20, 
	) );	
	
	// Enable or disable Block Stylesheet
	$wp_customize->add_setting( 'simplified_lite_block_css', array(
		'default'           => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'simplified_lite_block_css', array(
		'label'    => esc_html__( 'Disable the Block Stylesheet', 'simplified-lite' ),
        'description' => esc_html__( 'This theme includes support for the Gutenberg blocks styles, but you can disable if you do not use Gutenberg..', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
		'type'     => 'checkbox',
	) );	
	
	
	// Setting group for blog layout
	$wp_customize->add_setting( 'simplified_lite_blog_layout', array(
		'default' => 'blog1',
		'sanitize_callback' => 'simplified_lite_sanitize_select',
	) );  
	$wp_customize->add_control( 'simplified_lite_blog_layout', array(
		  'type' => 'radio',
		  'label' => esc_html__( 'Blog Layout', 'simplified-lite' ),
		  'section' => 'simplified_lite_theme_options',
		  'choices' => array(	
				'blog1' => esc_html__( 'Default With Right Sidebar', 'simplified-lite' ),	  
				'blog2' => esc_html__( 'Default With Left Sidebar', 'simplified-lite' ),						
				'blog4' => esc_html__( 'List With Right Sidebar', 'simplified-lite' ),
				'blog5' => esc_html__( 'List With Left Sidebar', 'simplified-lite' ),			
		) ) );	

	// Setting group for full post (single) layout  
	$wp_customize->add_setting( 'simplified_lite_single_layout', array(
		'default' => 'single1',
		'sanitize_callback' => 'simplified_lite_sanitize_select',
	) );  
	$wp_customize->add_control( 'simplified_lite_single_layout', array(
		  'type' => 'radio',
		  'label' => esc_html__( 'Full Post Style', 'simplified-lite' ),
		  'section' => 'simplified_lite_theme_options',
		  'choices' => array(	
				'single1' => esc_html__( 'Single With Right Sidebar', 'simplified-lite' ),	 
				'single2' => esc_html__( 'Single With Left Sidebar', 'simplified-lite' ), 
		) ) );	
	
	
	 // Use excerpts for blog posts
	  $wp_customize->add_setting( 'simplified_lite_use_excerpt',  array(
		  'default' => false,
		  'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
		) );  
	  $wp_customize->add_control( 'simplified_lite_use_excerpt', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Use Excerpts', 'simplified-lite' ),
		'description' => esc_html__( 'Use excerpts for your blog post summaries or uncheck the box to use the standard Read More tag. NOTE: Some blog styles only use excerpts.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	  ) );

    // Excerpt size
    $wp_customize->add_setting( 'simplified_lite_excerpt_size',  array(
            'sanitize_callback' => 'absint',
            'default'           => '35',
        ) );
    $wp_customize->add_control( 'simplified_lite_excerpt_size', array(
        'type'        => 'number',
        'section'     => 'simplified_lite_theme_options',
        'label'       => esc_html__('Excerpt Size', 'simplified-lite'),
		'description' => esc_html__('You can change the size of your blog summary excerpts with increments of 5 words.', 'simplified-lite'), 
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 200,
            'step'  => 1,
        ),
    ) );	  
	
	// Blog title 
	$wp_customize->add_setting( 'simplified_lite_blog_title', array(
		'default'    => '',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( 'simplified_lite_blog_title', array(
		'settings' => 'simplified_lite_blog_title',
		'label'    => esc_html__( 'Blog Title', 'simplified-lite' ),
		'description' => esc_html__('This is your blog title that shows up on your blog home page where post summaries are published.', 'simplified-lite'), 
		'section'  => 'simplified_lite_theme_options',		
		'type'     => 'text',
	) );  
	
	// Blog Introduction 
	$wp_customize->add_setting( 'simplified_lite_blog_intro', array(
		'default'    => '',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( 'simplified_lite_blog_intro', array(
		'settings' => 'simplified_lite_blog_intro',
		'label'    => esc_html__( 'Blog Introduction', 'simplified-lite' ),
		'description' => esc_html__('This is an introduction to your blog home page, much like a category description.', 'simplified-lite'), 
		'section'  => 'simplified_lite_theme_options',		
		'type'     => 'text',
	) );  
	
	// Show blog heading group
	$wp_customize->add_setting( 'simplified_lite_show_blog_heading',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_blog_heading', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Blog Heading Group', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the blog heading group that consists of the title and introduction on your home page.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );

	// Show blog heading group on full post
	$wp_customize->add_setting( 'simplified_lite_show_single_blog_title_group',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_single_blog_title_group', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Blog Heading Group on Full Post', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the blog heading group that consists of the title and introduction on your full post view.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );
	
	// Show page title on home
	$wp_customize->add_setting( 'simplified_lite_show_fp_title',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_fp_title', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Frontpage Page Title', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the title on the front page. This applies to the WP static front page only.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );	
	
	// Show featured label
	$wp_customize->add_setting( 'simplified_lite_show_featured_tag',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_featured_tag', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Featured Tag', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the featured tag in the post meta info.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );
	// Show featured image captions
	$wp_customize->add_setting( 'simplified_lite_show_featured_captions',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_featured_captions', array(
		'type'     => 'checkbox',
		'label'    => __( 'Show the Featured Image Captions', 'simplified-lite' ),
		'description' => __( 'This lets you show or hide the post summary featured image caption.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );

	// Show post date
	$wp_customize->add_setting( 'simplified_lite_show_post_date',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_post_date', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Post Date', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the post date in the meta info group for the summary.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );	
	
	// Show post author
	$wp_customize->add_setting( 'simplified_lite_show_post_author',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_post_author', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Post Author', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the post author in the meta info group for the summary.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );	
	
	// Show post comments
	$wp_customize->add_setting( 'simplified_lite_show_post_comments',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_post_comments', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Post Comment Link', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the post comment link in the meta info group for the summary.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );		
	
	// show hide edit link
	$wp_customize->add_setting( 'simplified_lite_show_edit_link',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_edit_link', array(
		'type'     => 'checkbox',
		'label'    => __( 'Show the Edit Link', 'simplified-lite' ),
		'description' => __( 'This lets you show or hide the front-end edit link.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );
	
	// Show author bio section
	$wp_customize->add_setting( 'simplified_lite_show_single_featured',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_single_featured', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Full Post Featured Image', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the featured image also on the full post view.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );	
	
	// Show full post nav
	$wp_customize->add_setting( 'simplified_lite_show_post_nav',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_post_nav', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Post Navigation', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the Next and Previous post navigation on the full post view.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );		

	// Show full post tags
	$wp_customize->add_setting( 'simplified_lite_show_entry_tags',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_entry_tags', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Tags Section', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the post tags list section in the full article view.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );
	
	// Show author bio section
	$wp_customize->add_setting( 'simplified_lite_show_author_bio',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_author_bio', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Author Bio Section', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the author biography section in the full article view.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );
	
	// Enable attachment comments
	$wp_customize->add_setting( 'simplified_lite_show_attachment_comments',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_attachment_comments', array(
		'type'     => 'checkbox',
		'label'    => __( 'Show Image Attachment Page Comments', 'simplified-lite' ),
		'description' => __( 'If you are using a WP gallery shortcode and want to showcase your images on the custom attachment page, you can enable or disable comments for images.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );	

	// hide image shadow
	$wp_customize->add_setting( 'simplified_lite_show_shadow',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_shadow', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the Image Drop Shadow', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );

	// hide widget title shadow
	$wp_customize->add_setting( 'simplified_lite_show_widget_title_shadow',	array(
		'default' => true,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_widget_title_shadow', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show the widget title bottom Shadow for the left and right sidebar widgets.', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',
	) );
	
	// Copyright
	$wp_customize->add_setting( 'simplified_lite_copyright', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( 'simplified_lite_copyright', array(
		'settings' => 'simplified_lite_copyright',
		'label'    => __( 'Your Copyright Name', 'simplified-lite' ),
		'section'  => 'simplified_lite_theme_options',		
		'type'     => 'text',
	) ); 
	
	
	
// SECTION - THUMBNAILS
	$wp_customize->add_section( 'simplified_lite_thumbnail_options' , array(
		'title'      => esc_html__( 'Thumbnail Options', 'simplified-lite' ),
		'priority' => 32,
	) );
	
	// Enable default thumbnails
	$wp_customize->add_setting( 'simplified_lite_default_thumbnails',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_default_thumbnails', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Default Style Blog Thumbnails', 'simplified-lite' ),
		'description' => esc_html__( 'This will create featured images for the blog 1 and 2 styled layouts. Size = 650x400 pixels.', 'simplified-lite' ),
		'section'  => 'simplified_lite_thumbnail_options',
	) );	

	// Enable List thumbnails with sidebar
	$wp_customize->add_setting( 'simplified_lite_list_sidebar_thumbnails',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_list_sidebar_thumbnails', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'List Style Blog with Sidebar Thumbnails', 'simplified-lite' ),
		'description' => esc_html__( 'This will create featured images for the list styled layouts with a left or right sidebar. Size = 300x360 pixels.', 'simplified-lite' ),
		'section'  => 'simplified_lite_thumbnail_options',
	) );	

	// Enable full post thumbnails
	$wp_customize->add_setting( 'simplified_lite_singlepost_thumbnails',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_singlepost_thumbnails', array(
		'type'     => 'checkbox',
		'label'    => __( 'Enable Full Post Thumbnail Creation', 'simplified-lite' ),
		'description' => __( 'When enabled, a custom thumbnail will be created for the Single Style 5 featured image. (Images will be 1024x500 pixels.', 'simplified-lite' ),
		'section'  => 'simplified_lite_thumbnail_options',
	) );	
	
	// Enable widget gallery thumbnails
	$wp_customize->add_setting( 'simplified_lite_widget_gallery_thumbnails',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_widget_gallery_thumbnails', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Widget Gallery Thumbnails', 'simplified-lite' ),
		'description' => esc_html__( 'This will create smaller thumbnails when creating galleries with the Gallery Widget by WordPress. Size will be 100x100 pixels.', 'simplified-lite' ),
		'section'  => 'simplified_lite_thumbnail_options',
	) );	

	

// ADD TO COLOUR SECTION	
	
// page top bar
 	$wp_customize->add_setting( 'simplified_lite_top_bar', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_top_bar', array(
		'label'   => esc_html__( 'Page Top Bar', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_top_bar',
		'section' => 'colors',
	) ) );
	
	
// page content background
 	$wp_customize->add_setting( 'simplified_lite_page_content_bg', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_page_content_bg', array(
		'label'   => esc_html__( 'Page Content Background', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_page_content_bg',
		'section' => 'colors',
	) ) );

// page content body text
 	$wp_customize->add_setting( 'simplified_lite_body_text', array(
		'default'        => '#686868',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_body_text', array(
		'label'   => esc_html__( 'Page Content Body Text', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_body_text',
		'section' => 'colors',
	) ) );
	
// breadcrumbs text
 	$wp_customize->add_setting( 'simplified_lite_breadcrumbs_text', array(
		'default'        => '#8e8e8e',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_breadcrumbs_text', array(
		'label'   => esc_html__( 'Breadcrumbs Text', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_breadcrumbs_text',
		'section' => 'colors',
	) ) );
	
// headings
 	$wp_customize->add_setting( 'simplified_lite_headings', array(
		'default'        => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_headings', array(
		'label'   => esc_html__( 'Headings Colour', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_headings',
		'section' => 'colors',
	) ) );	

//  widget title background
 	$wp_customize->add_setting( 'simplified_lite_widget_title_bg', array(
		'default'        => '#1a1a1a',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_widget_title_bg', array(
		'label'   => esc_html__( 'Widget Title Background', 'simplified-lite' ),	
		'description' => esc_html__( 'This will change the background colour on the widget titles  for the left and right sidebar widgets.', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_widget_title_bg',
		'section' => 'colors',
	) ) );
	
// widget title
 	$wp_customize->add_setting( 'simplified_lite_widget_title', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_widget_title', array(
		'label'   => esc_html__( 'Widget Title', 'simplified-lite' ),	
		'description' => esc_html__( 'This will change the colour for your widget title on the left and right sidebar widgets.', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_widget_title',
		'section' => 'colors',
	) ) );
	
// meta info hover
 	$wp_customize->add_setting( 'simplified_lite_meta_hover', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_meta_hover', array(
		'label'   => esc_html__( 'Post Meta Info Hover Links', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_meta_hover',
		'section' => 'colors',
	) ) );	
	
// links
 	$wp_customize->add_setting( 'simplified_lite_links', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_links', array(
		'label'   => esc_html__( 'Link Colour', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_links',
		'section' => 'colors',
	) ) );	

// links visited
 	$wp_customize->add_setting( 'simplified_lite_visited_links', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_visited_links', array(
		'label'   => esc_html__( 'Link Visited Colour', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_visited_links',
		'section' => 'colors',
	) ) );	

// links focus active hover
 	$wp_customize->add_setting( 'simplified_lite_hover_links', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_hover_links', array(
		'label'   => esc_html__( 'Link Active &amp; Hover Colour', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_hover_links',
		'section' => 'colors',
	) ) );	
	
	
// featured background
 	$wp_customize->add_setting( 'simplified_lite_featured_bg', array(
		'default'        => '#018aaa',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_featured_bg', array(
		'label'   => esc_html__( 'Featured Label Background', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_featured_bg',
		'section' => 'colors',
	) ) );	
	
// featured text
 	$wp_customize->add_setting( 'simplified_lite_featured_text', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_featured_text', array(
		'label'   => esc_html__( 'Featured Label', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_featured_text',
		'section' => 'colors',
	) ) );		
	
// tag cloud hover background
 	$wp_customize->add_setting( 'simplified_lite_tag_hover_bg', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_tag_hover_bg', array(
		'label'   => esc_html__( 'Tags Background Hover', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_tag_hover_bg',
		'section' => 'colors',
	) ) );		
	
// tag cloud hover text
 	$wp_customize->add_setting( 'simplified_lite_tag_hover_text', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_tag_hover_text', array(
		'label'   => esc_html__( 'Tags Text Hover', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_tag_hover_text',
		'section' => 'colors',
	) ) );		
	
// bottom sidebar background
 	$wp_customize->add_setting( 'simplified_lite_bottom_sidebar_bg', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_bottom_sidebar_bg', array(
		'label'   => esc_html__( 'Bottom Sidebar Background', 'simplified-lite' ),	
		'description' => esc_html__( 'This is the bottom sidebar area background colour.', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_bottom_sidebar_bg',
		'section' => 'colors',
	) ) );
// bottom sidebar text
 	$wp_customize->add_setting( 'simplified_lite_bottom_sidebar_text', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_bottom_sidebar_text', array(
		'label'   => esc_html__( 'Bottom Sidebar Text', 'simplified-lite' ),	
		'description' => esc_html__( 'This is the bottom sidebar area text and link colours, including the widget titles.', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_bottom_sidebar_text',
		'section' => 'colors',
	) ) );
// about widget hover social bg
 	$wp_customize->add_setting( 'simplified_lite_about_social_bg', array(
		'default'        => '#018aaa',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_about_social_bg', array(
		'label'   => esc_html__( 'About Author Social Background', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_about_social_bg',
		'section' => 'colors',
	) ) );	
	
// about widget hover social icon
 	$wp_customize->add_setting( 'simplified_lite_about_social_icon', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_about_social_icon', array(
		'label'   => esc_html__( 'About Author Social Icon', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_about_social_icon',
		'section' => 'colors',
	) ) );	
	
// about widget hover social bg
 	$wp_customize->add_setting( 'simplified_lite_about_social_hover_bg', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_about_social_hover_bg', array(
		'label'   => esc_html__( 'About Author Social Hover Background', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_about_social_hover_bg',
		'section' => 'colors',
	) ) );	
	
// about widget hover social icon
 	$wp_customize->add_setting( 'simplified_lite_about_social_hover_icon', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_about_social_hover_icon', array(
		'label'   => esc_html__( 'About Author Social Hover Icon', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_about_social_hover_icon',
		'section' => 'colors',
	) ) );	
	
	
// mobile menu toggle button
 	$wp_customize->add_setting( 'simplified_lite_mobile_toggle_button', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_mobile_toggle_button', array(
		'label'   => esc_html__( 'Mobile Toggle Button', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_mobile_toggle_button',
		'section' => 'colors',
	) ) );			
	
// mobile menu toggle label
 	$wp_customize->add_setting( 'simplified_lite_mobile_toggle_label', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_mobile_toggle_label', array(
		'label'   => esc_html__( 'Mobile Toggle Label', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_mobile_toggle_label',
		'section' => 'colors',
	) ) );		
	
// mobile menu toggle button on
 	$wp_customize->add_setting( 'simplified_lite_mobile_toggle_button_on', array(
		'default'        => '#0f0f0f',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_mobile_toggle_button_on', array(
		'label'   => esc_html__( 'Mobile Toggle Button On', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_mobile_toggle_button_on',
		'section' => 'colors',
	) ) );		
	
// mobile menu toggle label on
 	$wp_customize->add_setting( 'simplified_lite_mobile_toggle_label_on', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_mobile_toggle_label_on', array(
		'label'   => esc_html__( 'Mobile Toggle Label On', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_mobile_toggle_label_on',
		'section' => 'colors',
	) ) );		
	
// mobile menu lines
 	$wp_customize->add_setting( 'simplified_lite_mobile_menu_lines', array(
		'default'        => '#d1d1d1',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_mobile_menu_lines', array(
		'label'   => esc_html__( 'Mobile Menu Lines', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_mobile_menu_lines',
		'section' => 'colors',
	) ) );		

// submenu toggle arrow hover
 	$wp_customize->add_setting( 'simplified_lite_submenu_dropdown_arrow_hover', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_submenu_dropdown_arrow_hover', array(
		'label'   => esc_html__( 'Mobile Submenu Toggle Arrow Hover Colour', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_submenu_dropdown_arrow_hover',
		'section' => 'colors',
	) ) );	
	
// main menu wrapper top bottom lines
 	$wp_customize->add_setting( 'simplified_lite_menu_links', array(
		'default'        => '#afafaf',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_menu_links', array(
		'label'   => esc_html__( 'Main Menu Top &amp; Bottom Lines', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_menu_links',
		'section' => 'colors',
	) ) );	
	
// menu links
 	$wp_customize->add_setting( 'simplified_lite_menu_links', array(
		'default'        => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_menu_links', array(
		'label'   => esc_html__( 'Main Menu Links', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_menu_links',
		'section' => 'colors',
	) ) );		

// menu hover active links
 	$wp_customize->add_setting( 'simplified_lite_menu_active_link', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_menu_active_link', array(
		'label'   => esc_html__( 'Main Menu Active Hover Links', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_menu_active_link',
		'section' => 'colors',
	) ) );
	
// menu hover links
 	$wp_customize->add_setting( 'simplified_lite_menu_hover_links', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_menu_hover_links', array(
		'label'   => esc_html__( 'Main Menu Hover Links', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_menu_hover_links',
		'section' => 'colors',
	) ) );		
	
// submenu top border
 	$wp_customize->add_setting( 'simplified_lite_submenu_top_border', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_submenu_top_border', array(
		'label'   => esc_html__( 'Submenu Top Border', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_submenu_top_border',
		'section' => 'colors',
	) ) );		

// submenu hover background
 	$wp_customize->add_setting( 'simplified_lite_submenu_bg_hover', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_submenu_bg_hover', array(
		'label'   => esc_html__( 'Submenu Link Background Hover', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_submenu_bg_hover',
		'section' => 'colors',
	) ) );	
	
// submenu hover link
 	$wp_customize->add_setting( 'simplified_lite_submenu_link_hover', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_submenu_link_hover', array(
		'label'   => esc_html__( 'Submenu Link Hover', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_submenu_link_hover',
		'section' => 'colors',
	) ) );	

// full post nav background
 	$wp_customize->add_setting( 'simplified_lite_single_nav_bg', array(
		'default'        => '#1a1a1a',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_single_nav_bg', array(
		'label'   => esc_html__( 'Full Post Navigation Background', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_single_nav_bg',
		'section' => 'colors',
	) ) );	

// full post nav text
 	$wp_customize->add_setting( 'simplified_lite_single_nav_text', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_single_nav_text', array(
		'label'   => esc_html__( 'Full Post Navigation Text', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_single_nav_text',
		'section' => 'colors',
	) ) );	

// footer background
 	$wp_customize->add_setting( 'simplified_lite_footer_bg', array(
		'default'        => '#1a1a1a',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_footer_bg', array(
		'label'   => esc_html__( 'Footer Background', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_footer_bg',
		'section' => 'colors',
	) ) );	

// footer text and links
 	$wp_customize->add_setting( 'simplified_lite_footer_text', array(
		'default'        => '#d8d8d8',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_footer_text', array(
		'label'   => esc_html__( 'Footer Text &amp; Links', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_footer_text',
		'section' => 'colors',
	) ) );	
// footer link hover
 	$wp_customize->add_setting( 'simplified_lite_footer_link_hover', array(
		'default'        => '#d298b4',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_footer_link_hover', array(
		'label'   => esc_html__( 'Footer Hover Links', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_footer_link_hover',
		'section' => 'colors',
	) ) );		
// button
 	$wp_customize->add_setting( 'simplified_lite_button', array(
		'default'        => '#1a1a1a',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_button', array(
		'label'   => esc_html__( 'Buttons', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_button',
		'section' => 'colors',
	) ) );		
	
// button label
 	$wp_customize->add_setting( 'simplified_lite_button_label', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_button_label', array(
		'label'   => esc_html__( 'Button Label', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_button_label',
		'section' => 'colors',
	) ) );		
	
// button hover
 	$wp_customize->add_setting( 'simplified_lite_button_hover', array(
		'default'        => '#bb7514',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_button_hover', array(
		'label'   => esc_html__( 'Button Hover', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_button_hover',
		'section' => 'colors',
	) ) );		
	
// button label hover
 	$wp_customize->add_setting( 'simplified_lite_button_label_hover', array(
		'default'        => '#fff',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_button_label_hover', array(
		'label'   => esc_html__( 'Button Label Hover', 'simplified-lite' ),		
		'settings'   => 'simplified_lite_button_label_hover',
		'section' => 'colors',
	) ) );		
	

// SECTION - TYPOGRAPHY SETTINGS
    $wp_customize->add_section( 'simplified_lite_typography_settings', array(
        'title'       => esc_html__( 'Typography Options', 'simplified-lite' ),
        'priority'    => 41
    ) ); 	

		// Enable Default Google Fonts
		$wp_customize->add_setting( 'simplified_lite_default_google_fonts', array(
			'default'           => true,	
			'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
		) );

		$wp_customize->add_control( 'simplified_lite_default_google_fonts', array(
			'label'    => esc_html__( 'Enable the Default Google Fonts', 'simplified-lite' ),
			'description' => esc_html__( 'This theme has a couple Google Fonts included. If you choose to use a plugin for different fonts, you can disable them.', 'simplified-lite' ),
			'section'  => 'simplified_lite_typography_settings',
			'type'     => 'checkbox',
		) );	

	// Show dropcaps
	$wp_customize->add_setting( 'simplified_lite_show_dropcap',	array(
		'default' => false,
		'sanitize_callback' => 'simplified_lite_sanitize_checkbox',
	) );  
	$wp_customize->add_control( 'simplified_lite_show_dropcap', array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show Full Post Dropcap', 'simplified-lite' ),
		'description' => esc_html__( 'This lets you show the drop cap style on the first letter of the first paragraph.', 'simplified-lite' ),
		'section'  => 'simplified_lite_typography_settings',
	) );
	
// dropcap colour
 	$wp_customize->add_setting( 'simplified_lite_dropcap_colour', array(
		'default'        => '#333',
		'sanitize_callback' => 'sanitize_hex_color',
	) );	
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'simplified_lite_dropcap_colour', array(
		'label'   => esc_html__( 'Dropcap Letter Colour', 'simplified-lite' ),
		'section' => 'simplified_lite_typography_settings',
		'settings'   => 'simplified_lite_dropcap_colour',
	) ) );		
	
		
	
// End theme settings
	
}
add_action( 'customize_register', 'simplified_lite_customize_register' );


/**
 * SANITIZATION
 * Required for cleaning up bad inputs
 */

// Strip Slashes
	function simplified_lite_sanitize_strip_slashes($input) {
		return wp_kses_stripslashes($input);
	}	
	
// Radio and Select	
	function simplified_lite_sanitize_select( $input, $setting ) {
		// Ensure input is a slug.
		$input = sanitize_key( $input );
		// Get list of choices from the control associated with the setting.
		$choices = $setting->manager->get_control( $setting->id )->choices;
		// If the input is a valid key, return it; otherwise, return the default.
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
	 	
// Checkbox
	function simplified_lite_sanitize_checkbox( $input ) {
		// Boolean check 
		return ( ( isset( $input ) && true == $input ) ? true : false );
	}
	
// Array of valid image file types
	function simplified_lite_sanitize_image( $image, $setting ) {
		$mimes = array(
			'jpg|jpeg|jpe' => 'image/jpeg',
			'gif'          => 'image/gif',
			'png'          => 'image/png',
		);
		// Return an array with file extension and mime_type.
		$file = wp_check_filetype( $image, $mimes );
		// If $image has a valid mime_type, return it; otherwise, return the default.
		return ( $file['ext'] ? $image : $setting->default );
	}


// Adds sanitization callback function: Slider Category
function simplified_lite_sanitize_slidecat( $input ) {

	if ( array_key_exists( $input, simplified_lite_cats() ) ) {
		return $input;
	} else {
		return '';
	}
}

// Adds sanitization callback function: Number
function simplified_lite_sanitize_number( $input ) {
	if ( isset( $input ) && is_numeric( $input ) ) {
		return $input;
	}
}

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function simplified_lite_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function simplified_lite_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function simplified_lite_customize_preview_js() {
	wp_enqueue_script( 'simplified-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'simplified_lite_customize_preview_js' );
