<?php

function simplified_litesetup() {    

	/**
	 * About page class
	 */
	//require_once get_template_directory() . '/inc/about/simplified-class-about.php';

	/*
	* About page instance
	*/

	// Get theme data
	$theme_data     = wp_get_theme();

	// Get name of parent theme
	$theme_name    = trim( strtolower( str_replace( ' (Lite)', '', $theme_data->get( 'Name' ) ) ) );
	$theme_slug    = trim( strtolower( str_replace( ' (Lite)', '-lite', $theme_data->get( 'Name' ) ) ) );
	$theme_version = $theme_data->get( 'Version' );


	$config = array(
		// Menu name under Appearance.
		'menu_name'             => sprintf( 
		// translators: %1$s: theme name 
		__( 'About %1$s', 'simplified-lite' ), ucwords( $theme_name ) ),
		// Page title.
		'page_name'             => sprintf( 
		// translators: %1$s: theme name 
		__( 'About %1$s', 'simplified-lite' ), ucwords( $theme_name ) ),
		// Main welcome title
		'welcome_title'         => sprintf( 
		// translators: %1$s: theme name 
		__( 'Welcome to %1$s', 'simplified-lite' ), ucwords( $theme_name ) ),
		// Main welcome content
		'welcome_content'       => sprintf( 
		// translators: %1$s: theme name 
		esc_html__(  '%1$s is a clean and minimalist theme that allows your reader to focus on your content. We built this theme for daily or hobby bloggers who love to share their lives. Whether it is about food, life, fashion, travel, beauty, or just a simple, personal blog, you will definitely stand out. Featuring a clean, elegant design, this theme is guaranteed to bring a pleasant reading experience to your readers. Simplified Lite is compatible with both the Classic and Gutenberg editors.', 'simplified-lite' ), ucwords( $theme_name ) ),
		/**
		 * Tabs array.
		 *
		 * The key needs to be ONLY consisted from letters and underscores. If we want to define outside the class a function to render the tab,
		 * the will be the name of the function which will be used to render the tab content.
		 */
		'upgrade'             => array(
			'upgrade_url'     => 'https://www.bloggingthemestyles.com/wordpress-themes/simplified-pro/',
			'price_discount'  => __( 'Upgrade and Save 5%', 'simplified-lite' ),
			'price_normal'	  => __( 'Use coupon at checkout.', 'simplified-lite' ),
			'coupon'	      =>  __( 'SAVEFIVE', 'simplified-lite' ),
			'button'	      => __( 'Get the Pro', 'simplified-lite' ),
		),
		'tabs'                 => array(
			'getting_started'  => __( 'Getting Started', 'simplified-lite' ),
			'support_content'  => __( 'Support', 'simplified-lite' ),
			'changelog'  => __( 'Changelog', 'simplified-lite' ),
			'free_pro'         => __( 'Free VS PRO', 'simplified-lite' ), 
		),
		// Getting started tab
		'getting_started' => array(
			'first' => array (
				'title'               => esc_html__( 'Setup Documentation', 'simplified-lite' ),
				'text'                => sprintf( esc_html__( 'To help you get started with the initial setup of this theme and to learn about the various features, you can check out our detailed setup documentation.', 'simplified-lite' ) ),
				// translators: %1$s: theme name 
				'button_label'        => sprintf( esc_html__( 'View %1$s Tutorials', 'simplified-lite' ), ucwords( $theme_name ) ),
				'button_link'         => esc_url( '//www.bloggingthemestyles.com/documentation/' ),
				'is_button'           => true,
				'recommended_actions' => false,
                'is_new_tab'          => true,
			),
			'second' => array(
				'title'               => esc_html__( 'Go to Customizer', 'simplified-lite' ),
				'text'                => esc_html__( 'Using the WordPress Customizer, you can easily customize every aspect of the theme.', 'simplified-lite' ),
				'button_label'        => esc_html__( 'Go to Customizer', 'simplified-lite' ),
				'button_link'         => esc_url( admin_url( 'customize.php' ) ),
				'is_button'           => true,
				'recommended_actions' => false,
                'is_new_tab'          => true,
			),
			
			'third' => array(
				'title'               => esc_html__( 'Using a Child Theme', 'simplified-lite' ),
				'text'                => sprintf( esc_html__( 'If you plan to customize this theme, I recommend looking into using a child theme. To learn more about child themes and why it\'s important to use one, check out the WordPress documentation.', 'simplified-lite' ) ),
				'button_label'        => sprintf( esc_html__( 'Child Themes', 'simplified-lite' ), ucwords( $theme_name ) ),
				'button_link'         => esc_url( '//developer.wordpress.org/themes/advanced-topics/child-themes/' ),
				'is_button'           => true,
				'recommended_actions' => false,
                'is_new_tab'          => true,
			),		
		),	
			
		
		
		// Changelog content tab.
		'changelog'      => array(
			'first' => array (				
				'title'        => esc_html__( 'Changelog', 'simplified-lite' ),
				'text'         => esc_html__( 'I generally recommend you always read the CHANGELOG before updating so that you can see what was fixed, changed, deleted, or added to the theme.', 'simplified-lite' ),	
				'button_label' => '',
				'button_link'  => '',
				'is_button'    => false,
				'is_new_tab'   => false,				
				),
		),	

		// Support content tab.
		'support_content'      => array(
			'first' => array (
				'title'        => esc_html__( 'Support', 'simplified-lite' ),
				'icon'         => 'dashicons dashicons-sos',
				'text'         => esc_html__( 'If you experience any problems, please post your questions to support and we will be more than happy to help you out.', 'simplified-lite' ),
				'button_label' => esc_html__( 'Get Support', 'simplified-lite' ),
				'button_link'  => esc_url( '//www.bloggingthemestyles.com/support' ),
				'is_button'    => true,
				'is_new_tab'   => true,
			),

		),	
		
		/*
		 * Use for the free theme version
		 * Free vs pro array
		 */
		'free_pro'                => array(
			'free_theme_name'     => ucwords( $theme_name ) . ' (Free)',
			'pro_theme_name'      => ucwords( $theme_name ) . ' PRO',
			'pro_theme_link'      => 'https://www.bloggingthemestyles.com/wordpress-themes/simplified-pro/',
			'get_pro_theme_label' => sprintf( 
			// translators: %1$s: theme name 
			__( 'Get %s Now!', 'simplified-lite' ), ucwords( $theme_name ) . ' Pro' ),
		'features'    => array(
				array(
					'title'    => esc_html__( 'Gutenberg Ready', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),	
				array(
					'title'    => esc_html__( 'Classic Editor Compatible', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),		
				array(
					'title'   => esc_html__( 'Disable All Block Styles', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),						
				array(
					'title'   => esc_html__( 'Mobile Friendly', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),		
				array(
					'title'            => esc_html__( 'Change Accent Colours', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),						
				array(
					'title'            => esc_html__( 'Built-In Social Menu', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),
				array(
					'title'            => esc_html__( 'Show or Hide Elements', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),				
				array(
					'title'            => esc_html__( 'Custom Error Page', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),		
				
				array(
					'title'            => esc_html__( 'Blog Styles', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '4',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '14',
					'hidden'           => '',
				),		
				array(
					'title'            => esc_html__( 'Full Post Layouts', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '2',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '4',
					'hidden'           => '',
				),					
				array(
					'title'            => esc_html__( 'Sidebar Positions', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '10',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '12',
					'hidden'           => '',
				),
				array(
					'title'            => esc_html__( 'Page Templates', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '3',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '3',
					'hidden'           => '',
				),
			
				array(
					'title'            => esc_html__( 'Theme Options', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'true',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),		
				array(
					'title'            => esc_html__( 'Recent Posts Widget with Thumbnails', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),		
				array(
					'title'            => esc_html__( 'Support', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => '',
					'is_in_lite_text'  => 'Basic',
					'is_in_pro'        => '',
					'is_in_pro_text'   => 'Premium',
					'hidden'           => '',
				),		

				array(
					'title'            => esc_html__( 'About Me Widget', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),	
				array(
					'title'            => esc_html__( 'Social Links Widget', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),						
				array(
					'title'            => esc_html__( 'Related Posts w/Thumbnails', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),								
				array(
					'title'            => esc_html__( 'Blog Thumbnail Creation', 'simplified-lite' ),
					'description'      => esc_html__('Automatically have post featured images cropped when uploading. You get a couple with the free version but more with the Pro.', 'simplified-lite'),
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),	
				
				array(
					'title'            => esc_html__( 'Customizable Read More Text', 'simplified-lite' ),
					'description'      => esc_html__('You can change the Read More text to display what you want.', 'simplified-lite'),
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),	
				array(
					'title'            => esc_html__( 'Font Extras', 'simplified-lite' ),
					'description'      => 'You can disable the Google fonts used in this theme, but in the pro you get a few more basic options for font management',
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),			
				array(
					'title'            => esc_html__( '1-Click Demo Content Import Compatible', 'simplified-lite' ),
					'description'      => esc_html__('We included the ability to let you import the demo site content.', 'simplified-lite'),
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),										
				array(
					'title'            => esc_html__( 'Custom Styled Archive Titles', 'simplified-lite' ),
					'description'      => esc_html__('We customized the style of archive titles for tags, categories, etc.', 'simplified-lite'),
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),				
				array(
					'title'            => esc_html__( 'Show or Hide the Featured Post Label', 'simplified-lite' ),
					'description'      => '',
					'is_in_lite'       => 'false',
					'is_in_lite_text'  => '',
					'is_in_pro'        => 'true',
					'is_in_pro_text'   => '',
					'hidden'           => '',
				),					
			),
		),
				 
	);
	simplified_lite_about_page::init( $config );

}

add_action('after_setup_theme', 'simplified_litesetup');

?>
