<?php
/**
 * The header for our theme
 * @package Simplified_Lite
 */
 $singlelayout = get_theme_mod( 'simplified_lite_single_layout', 'single1' );
?><!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <div id="page" class="hfeed site">
        <a class="skip-link screen-reader-text" href="#content">
            <?php esc_html_e( 'Skip to content', 'simplified-lite' ); ?></a>

        <header id="masthead" class="site-header">
            <div id="site-branding" style="padding:<?php echo esc_attr(get_theme_mod( 'simplified_lite_header_size', '20' ) ); ?>px 0;">

                <?php if ( has_custom_logo() ) : ?>
                <?php the_custom_logo(); ?>
                <?php endif; ?>

                <?php if ( esc_attr(get_theme_mod( 'simplified_lite_show_site_title', true ) ) ) : ?>
                <h1 id="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                        <?php bloginfo( 'name' ); ?></a></h1>
                <?php endif; ?>

                <?php	if (esc_attr(get_theme_mod( 'simplified_lite_show_site_desc', true ) ) ) :
				$simplified_lite_description = get_bloginfo( 'description', 'display' );
					if ( $simplified_lite_description || is_customize_preview() ) : ?>
                <p id="site-description">
                    <?php echo esc_html( $simplified_lite_description );  /* WPCS: xss ok. */ ?>
                </p>
                <?php 
					endif;
				endif; ?>
            </div><!-- .site-branding -->

        </header><!-- #masthead -->

        <div id="nav-wrapper">
            <?php if ( has_nav_menu( 'primary' ) ) : ?>
            <button id="menu-toggle" class="menu-toggle">
                <?php esc_html_e( 'Menu', 'simplified-lite' ); ?></button>
            <div id="site-header-menu" class="site-header-menu">
                <?php if ( has_nav_menu( 'primary' ) ) : ?>
                <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Primary Menu', 'simplified-lite' ); ?>">
                    <?php
						wp_nav_menu( array(
							'theme_location' => 'primary',
							'menu_class'     => 'primary-menu',
						 ) );
					?>
                </nav><!-- .main-navigation -->
                <?php endif; ?>

            </div><!-- .site-header-menu -->
            <?php endif; ?>
        </div>


        <?php get_template_part( 'template-parts/sidebars/sidebar', 'banner' ); ?>

        <?php	// Whenever a page has a featured image
	if ( '' !== get_the_post_thumbnail() && is_page() ) :  
	echo '<div id="page-featured-wrapper"><div class="featured-image">';		
		the_post_thumbnail( 'post-thumbnail', array( 'alt' => the_title_attribute( 'echo=0' ), 'class' => ''));		
	echo '</div></div>';			
	endif; 
	?>

        <div id="content" class="site-content container">
            <div class="row">
