<?php
/**
 *
 * @package sanremo
 */

global $sanremo_site_layout;
$sanremo_site_layout = array(
					'ot-sidebar-left' =>  esc_html__('Left Sidebar','sanremo'),
					'ot-sidebar-right' => esc_html__('Right Sidebar','sanremo'),
					'no-sidebar' => esc_html__('No Sidebar','sanremo'),
					'ot-full-width' => esc_html__('Full Width', 'sanremo')
					);

if ( ! function_exists( 'sanremo_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function sanremo_setup() {

	/*
	* Make theme available for translation.
	* Translations can be filed in the /languages/ directory.
	*/
	load_theme_textdomain( 'sanremo', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	// Set the content width based on the theme's design and stylesheet.
	global $content_width;
	if ( ! isset( $content_width ) ) {
	$content_width = 640; /* pixels */
	} 

	/**
	* Enable support for Post Thumbnails on posts and pages.
	*
	* @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	*/
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'sanremo-slider', 1140, 550, true );
	add_image_size( 'sanremo-thumbnail', 750, 500, true );
	add_image_size( 'sanremo-author-thumbnail', 170, 170, true );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
	'top-menu' => esc_html__( 'Top Menu', 'sanremo' ),
	'footer-menu' => esc_html__( 'Footer Menu', 'sanremo' ) // secondary nav in footer
	) );

	/*
	* Switch default core markup for search form, comment form, and comments
	* to output valid HTML5.
	*/
	add_theme_support( 'html5', array(
	'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
	) );

	// Enable support for Post Formats.
	add_theme_support( 'post-formats', array( 'aside', 'image', 'audio', 'video', 'quote', 'link' ) );

	// Setup the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'sanremo_custom_background_args', array(
	'default-color' => 'F5F5F5',
	'default-image' => '',
	) ) );

	add_theme_support( 'custom-logo', array(
		'height'      => 140,
		'width'       => 320,
		'flex-height' => true,
	) );

	/*
	* Let WordPress manage the document title.
	* By adding theme support, we declare that this theme does not use a
	* hard-coded <title> tag in the document head, and expect WordPress to
	* provide it for us.
	*/
	add_theme_support( 'title-tag' );

}
endif; // sanremo_setup
add_action( 'after_setup_theme', 'sanremo_setup' );

/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 */
if ( ! function_exists( 'sanremo_the_custom_logo' ) ) :
function sanremo_the_custom_logo() {
	// Try to retrieve the Custom Logo
	$output = '';
	if ((function_exists('the_custom_logo'))&&(has_custom_logo())) {
		the_custom_logo();

		// Nothing in the output: Custom Logo is not supported, or there is no selected logo
		// In both cases we display the site's name
	} else {
		echo '<hgroup><h1><a href="' . esc_url(home_url('/')) . '" rel="home">' . esc_html(get_bloginfo('name')) . '</a></h1><div class="description">'.esc_html(get_bloginfo('description')).'</div></hgroup>';
	}
}
endif; // sanremo_custom_logo

/*
 * Add Bootstrap classes to the main-content-area wrapper.
 */
if ( ! function_exists( 'sanremo_content_bootstrap_classes' ) ) :
function sanremo_content_bootstrap_classes() {
	if ( is_page_template( 'page-fullwidth.php' ) ) {
		return 'col-md-12';
	}
	return 'col-md-8';
}
endif; // sanremo_content_bootstrap_classes

/*
 * Checked if function is exits, if not exits then make a function called wp_body_open();
 */
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}

/*
 * Generate categories for slider customizer
 */
function sanremo_cats() {
	$cats = array();
	$cats[0] = "All";
	
	foreach ( get_categories() as $categories => $category ) {
		$cats[$category->term_id] = $category->name;
	}

	return $cats;
}

/*
 * generate navigation from default bootstrap classes
 */
require_once('inc/wp_bootstrap_navwalker.php');

if ( ! function_exists( 'sanremo_header_menu' ) ) :
/*
 * Header menu (should you choose to use one)
 */
function sanremo_header_menu() {
	/* display the WordPress Custom Menu if available */
	wp_nav_menu(array(
		'menu'              => 'top-menu',
		'theme_location'    => 'top-menu',
		'depth'             => 2,
		'container'         => 'div',
		'container_class'   => 'collapse navbar-collapse navbar-ex1-collapse',
		'menu_class'        => 'nav navbar-nav',
		'fallback_cb'       => 'sanremo_bootstrap_navwalker::fallback',
		'walker'            => new sanremo_bootstrap_navwalker()
	));
} /* end header menu */
endif;


function sanremo_fonts_url() { 
	$fonts_url = '';

	//Add all fonts in array
	$font_families = array();
	$font_settings = ':300,400,500,600,700,900';
	for( $i=1; $i<=5; $i++ ) {
		if( get_theme_mod( 'sanremo_font_'.$i ) ) {
			if( get_theme_mod('sanremo_font_'.$i) != "Arial" ) {
				$font_families[] = get_theme_mod('sanremo_font_'.$i).$font_settings;		
			}
		}
	}
	//remove duplicate fonts
	$font_families = array_unique($font_families);

	//include fonts
	$googleFontUrl = '//fonts.googleapis.com/css';
	$newGoogleFontUrl = add_query_arg( array(
		'family' => urlencode( implode( '|', $font_families ) )
	), $googleFontUrl );


	return esc_url_raw( $newGoogleFontUrl );	

}

/*
 * load css/js
 */
function sanremo_scripts() {

	// Add Bootstrap default CSS
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css' );
	wp_enqueue_style( 'slick', get_template_directory_uri().'/css/slick.css' );
	//  wp_enqueue_style( 'sanremo-slick-theme', get_template_directory_uri().'/css/slick-theme.css' );
	wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/css/font-awesome.css' );

	// Add Google Fonts
	wp_enqueue_style( 'google-fonts', '//fonts.googleapis.com/css?family=Crimson+Text:400,400italic|Open+Sans:400,700|Oswald:300,400,500,700');

	// Add main theme stylesheet
	wp_enqueue_style( 'sanremo-style', get_stylesheet_uri() );

	// Add JS Files
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/js/bootstrap.min.js', array('jquery') );
	wp_enqueue_script( 'slick', get_template_directory_uri() . '/js/slick.min.js', array('jquery') );
	wp_enqueue_script( 'sanremo-js', get_template_directory_uri() . '/js/sanremo.min.js', array('jquery') );

	// Threaded comments
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
	}

	wp_enqueue_style( 'sanremo-fonts', sanremo_fonts_url(), array(), null );



}
add_action( 'wp_enqueue_scripts', 'sanremo_scripts' );

/*
 * Customizer additions.
 */
require get_template_directory() . '/inc/extras.php';
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/template_tags.php';

if ( ! function_exists( 'sanremo_woo_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 */
function sanremo_woo_setup() {
	/*
	 * Enable support for WooCemmerce.
	*/
	add_theme_support( 'woocommerce' );
}
endif; // sanremo_woo_setup
add_action( 'after_setup_theme', 'sanremo_woo_setup' );

/*
 * Add custom colors css to header
 */
if (!function_exists('sanremo_custom_css_output'))  {
	function sanremo_custom_css_output() {

		echo '<style type="text/css" id="sanremo-custom-theme-css">';

		if ( get_theme_mod('sanremo_link_hover_color')) {
			echo 'a:hover, a:focus, a:active, a.active { color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.blog-post .blog-post-body a:hover { color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.widget-socials a:hover { color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.widget-post h2 a:hover { color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .

			'.widget_categories a:hover { color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.widget_tag_cloud a:hover { background-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; border-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .

			'.btn-default:hover { background-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; border-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.read-more a:hover { background-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; border-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover { background-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; border-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'#back-top a:hover { background-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.page-numbers li a:hover { background-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; border-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.page-numbers .current { background-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; border-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }' .
			'.mz-footer .widget-title { border-color: ' . get_theme_mod( 'sanremo_link_hover_color' ) . '; }';
		}
		if ( get_theme_mod('sanremo_titles_color')) {
			echo '.sidebar-title { color: ' . get_theme_mod( 'sanremo_titles_color' ) . '; }';
		}
		if ( get_theme_mod('sanremo_accent_color')) {
			echo '.blog-post .post-cats a { color: ' . get_theme_mod( 'sanremo_accent_color' ) . '; }' .
			'.sidebar-title { border-color: ' . get_theme_mod( 'sanremo_accent_color' ) . '; }' .
			'.mz-footer .widget-title { border-color: ' . get_theme_mod( 'sanremo_accent_color' ) . '; }' .
			'.null-instagram-feed p a { color: ' . get_theme_mod( 'sanremo_accent_color' ) . '; }' .
			'.ot-widget-about-author .author-post .author-position { color: ' . get_theme_mod( 'sanremo_accent_color' ) . '; }' .
			'button, input[type="button"], input[type="reset"], input[type="submit"] { color: ' . get_theme_mod( 'sanremo_accent_color' ) . '; }' .
			'.blog-post .read-more a { color: ' . get_theme_mod( 'sanremo_accent_color' ) . '; }';
		}

		$font_1 = get_theme_mod('sanremo_font_1');
		$font_2 = get_theme_mod('sanremo_font_2');
		$font_3 = get_theme_mod('sanremo_font_3');
		$font_4 = get_theme_mod('sanremo_font_4');


		if( $font_1 ) {
			//main font
			echo '
				body, label {
					font-family: "'.esc_attr( $font_1 ).'", Sans-serif;
				}
			';

		}

		if( $font_2 ) {
			//header fonts
			echo '
				h1,
				h2,
				h3,
				h4,
				h5,
				h6 {
					font-family: "'.esc_attr( $font_2 ).'", Sans-serif;
				}
			';
		}	

		if( $font_3 ) {
			//text fonts
			echo '
				p {
					font-family: "'.esc_attr( $font_3 ).'", sans-serif;
				}
			';
		}	

		if( $font_4 ) {
			//widget titles
			echo '
				.mz-footer .widget-title, .sidebar-title {
					font-family: "'.esc_attr( $font_4 ).'", Sans-serif;
				}
			';
		}		


		echo "</style>";
	}
}
add_action( 'wp_head', 'sanremo_custom_css_output');

/*
 * Register widget areas.
 */

// if no title then add widget content wrapper to before widget
add_filter( 'dynamic_sidebar_params', 'sanremo_sidebar_params' );
function sanremo_sidebar_params( $params ) {
	global $wp_registered_widgets;

	$settings_getter = $wp_registered_widgets[ $params[0]['widget_id'] ]['callback'][0];
	$settings = $settings_getter->get_settings();
	$settings = $settings[ $params[1]['number'] ];

	if ( $params[0][ 'after_widget' ] == '</div></div>' && isset( $settings[ 'title' ] ) && empty( $settings[ 'title' ] ) )
		$params[0][ 'before_widget' ] .= '<div class="content">';

	return $params;
}

function sanremo_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Primary Sidebar', 'sanremo' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Main sidebar that appears on the left.', 'sanremo' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="sidebar-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Content Sidebar', 'sanremo' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Additional sidebar that appears on the right.', 'sanremo' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="sidebar-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Widget 1', 'sanremo' ),
		'id'            => 'footer-widget-1',
		'description'   => __( 'Appears in the footer section of the site.', 'sanremo' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Widget 2', 'sanremo' ),
		'id'            => 'footer-widget-2',
		'description'   => __( 'Appears in the footer section of the site.', 'sanremo' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Widget 3', 'sanremo' ),
		'id'            => 'footer-widget-3',
		'description'   => __( 'Appears in the footer section of the site.', 'sanremo' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Full Width Footer Wide Widget', 'sanremo' ),
		'id'            => 'footer-wide-widget',
		'description'   => __( 'Full width footer area for Instagram, etc. Appears in the footer section after widgets.', 'sanremo' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_widget( 'sanremo_recent_posts' );
	register_widget( 'sanremo_social_widget' );
}
add_action( 'widgets_init', 'sanremo_widgets_init' );

function sanremo_widget_content_wrap($content) {
	$content = '<div class="block-content">'.$content.'</div>';
	return $content;
}
add_filter('widget_calendar', 'sanremo_widget_content_wrap');

/*
 * Theme Widgets
 */
require_once(get_template_directory() . '/inc/widgets/widget-sanremo-posts.php');
require_once(get_template_directory() . '/inc/widgets/widget-sanremo-social.php');

/*
 * Misc. functions
 */

/**
 * Footer credits
 */
function sanremo_footer_credits() {
	?>
	<div class="site-info">
	&copy; <?php echo date('Y'); ?> <?php bloginfo( 'name' ); ?><?php esc_html_e('. All rights reserved.', 'sanremo'); ?>
	</div><!-- .site-info -->

	<?php
	printf( esc_html__( 'Theme by %1$s Powered by %2$s', 'sanremo' ) , '<a href="https://moozthemes.com" rel="nofollow" target="_blank">MOOZ Themes</a>', '<a href="http://wordpress.org/" target="_blank">WordPress</a>');
}
add_action( 'sanremo_footer', 'sanremo_footer_credits' );

/* Wrap Post count in a span */
add_filter('wp_list_categories', 'sanremo_cat_count_span');
function sanremo_cat_count_span($links) {
	$links = str_replace('</a> (', '</a> <span>', $links);
	$links = str_replace(')', '</span>', $links);
	return $links;
}

// Remove search text from search widget
add_filter('get_search_form', 'sanremo_search_form');
 
function sanremo_search_form($text) {
	$text = str_replace('value="Search"', 'value=""', $text);
	return $text;
}


function sanremo_json_response( $url, $type = false )	{
		$args = array(
			 'timeout' => '10',
			 'redirection' => '10',
			 'sslverify' => false // for localhost
		);
		
		# Parse the given url
		$raw = wp_remote_get( $url, $args );
		if (!is_wp_error($raw)) {	
			if($type!=false) {
				$decoded = json_decode( $raw['body'],$type );	
			} else {
				$decoded = json_decode( $raw['body'] );
			}
			
			return $decoded;
		} else {

			//return $url;	
			return false;	
		}

}


/* -------------------------------------------------------------------------*
 * 								GET GOOGLE FONTS							*
 * -------------------------------------------------------------------------*/
 
function sanremo_get_google_fonts( $sort = "alpha" ) {

	$font_list = get_option("sanremo_google_font_list");
	$font_list_time = get_option("sanremo_google_font_list_update");
	$now = time();
	$interval = 41600;
	
	if($font_list && (( $now - $font_list_time ) < $interval)) {
		$font_list = $font_list;
	} else if(!$font_list || (( $now - $font_list_time ) > $interval)) {
		$url = "https://www.googleapis.com/webfonts/v1/webfonts?key=AIzaSyCpatq_HIaUbw1XUxVAellP4M1Uoa6oibU&sort=" . $sort;
		
		$result = sanremo_json_response( $url );

		if($result!=false) {
			$font_list = array();
			foreach ( $result->items as $font ) {
				if(isset($font->family)) {
					$font_list[$font->family] = $font->family;	
				}
			}

			update_option("sanremo_google_font_list",$font_list);
			update_option("sanremo_google_font_list_update",time());
		} else {
			$font_list = false;
		}

	} else {
		$font_list = false;
	}

		
	return $font_list;
	
}

require_once(get_template_directory() . '/inc/class-tgm-plugin-activation.php');
add_action( 'tgmpa_register', 'sanremo_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
function sanremo_register_required_plugins() {

/**
 * Array of plugin arrays. Required keys are name and slug.
 * If the source is NOT from the .org repo, then source is also required.
 */

$plugins = array(
	// This is an example of how to include a plugin pre-packaged with a theme
	array(
		'name'         => 'Orange Themes Custom Widgets', // The plugin name
		'slug'         => 'orange-themes-custom-widgets', // The plugin slug (typically the folder name)
		'required'     => true, // If false, the plugin is only 'recommended' instead of required
		'version'     => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
		'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
		'force_deactivation'  => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
		'external_url'    => '', // If set, overrides default API URL and points to an external URL
	),  
);

 /**
  * Array of configuration settings. Amend each line as needed.
  * If you want the default strings to be available under your own theme domain,
  * leave the strings uncommented.
  * Some of the strings are added into a sprintf, so see the comments at the
  * end of each line for what each argument will be.
  */
	$config = array(
		'domain'         => 'sanremo',          // Text domain - likely want to be the same as your theme.
		'default_path'   => '',                          // Default absolute path to pre-packaged plugins
		'menu'           => 'install-required-plugins',  // Menu slug
		'has_notices'       => true,                        // Show admin notices or not
		'is_automatic'     => false,         // Automatically activate plugins after installation or not
		'message'    => '',       // Message to output right before the plugins table
		'strings'        => array(
		'page_title'                          => __('Install Required Plugins','sanremo'),
		'menu_title'                          => __('Install Plugins','sanremo'),
		'installing'                          => __('Installing Plugin: %s','sanremo'), // %1$s = plugin name
		'oops'                                => __('Something went wrong with the plugin API.','sanremo'),
		'notice_can_install_required'        => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.','sanremo' ), // %1$s = plugin name(s)
		'notice_can_install_recommended'   => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.','sanremo' ), // %1$s = plugin name(s)
		'notice_cannot_install'       => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.','sanremo' ), // %1$s = plugin name(s)
		'notice_can_activate_required'       => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.','sanremo' ), // %1$s = plugin name(s)
		'notice_can_activate_recommended'   => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.','sanremo' ), // %1$s = plugin name(s)
		'notice_cannot_activate'      => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.','sanremo' ), // %1$s = plugin name(s)
		'notice_ask_to_update'       => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.','sanremo' ), // %1$s = plugin name(s)
		'notice_cannot_update'       => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.','sanremo' ), // %1$s = plugin name(s)
		'install_link'           => _n_noop( 'Begin installing plugin', 'Begin installing plugins','sanremo' ),
		'activate_link'          => _n_noop( 'Activate installed plugin', 'Activate installed plugins','sanremo' ),
		'return'                              => __('Return to Required Plugins Installer','sanremo'),
		'plugin_activated'                    => __('Plugin activated successfully.','sanremo'),
		'complete'          => __('All plugins installed and activated successfully. %s','sanremo'), // %1$s = dashboard link
		'nag_type'         => 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		)
	);

	tgmpa( $plugins, $config );
}