<?php
//about theme info
add_action( 'admin_menu', 'fashion_designer_gettingstarted' );
function fashion_designer_gettingstarted() {
	add_theme_page( esc_html__('About Fashion Designer', 'fashion-designer'), esc_html__('Theme Demo Import', 'fashion-designer'), 'edit_theme_options', 'fashion_designer_guide', 'fashion_designer_mostrar_guide');
}

// Add a Custom CSS file to WP Admin Area
function fashion_designer_admin_theme_style() {
   wp_enqueue_style('fashion-designer-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstarted/getstarted.css');
   wp_enqueue_script('fashion-designer-tabs', esc_url(get_template_directory_uri()) . '/inc/getstarted/js/tab.js');
}
add_action('admin_enqueue_scripts', 'fashion_designer_admin_theme_style');

//guidline for about theme
function fashion_designer_mostrar_guide() { 
	//custom function about theme customizer
	$fashion_designer_return = add_query_arg( array()) ;
	$fashion_designer_theme = wp_get_theme( 'fashion-designer' );
?>

<div class="wrap getting-started">
	<div class="getting-started__header">
	    <div>
            <h2 class="tgmpa-notice-warning"></h2>
        </div>
	</div>
	<div class="tab-sec">
		<div class="tab">
			<button role="tab" class="tablinks home" onclick="fashion_designer_openCity(event, 'bwp_getstart')"><?php esc_html_e( 'Getting Started', 'fashion-designer' ); ?></button>
			<button role="tab" class="tablinks" onclick="fashion_designer_openCity(event, 'bwp_setup')"><?php esc_html_e( 'Free Theme Information', 'fashion-designer' ); ?></button>
			<button role="tab" class="tablinks" onclick="fashion_designer_openCity(event, 'bwp_premium_info')"><?php esc_html_e( 'Premium Theme Information', 'fashion-designer' ); ?></button>
			<a class="tablinks tablinks-demo" role="tab" href="<?php echo esc_url( FASHION_DESIGNER_LIVE_DEMO ); ?>" target="_blank">
				<?php esc_html_e( 'Live Demo', 'fashion-designer' ); ?>
			</a>
			<a class="tablinks tablinks-pro" role="tab" href="<?php echo esc_url( FASHION_DESIGNER_BUY_NOW ); ?>" target="_blank">
				<?php esc_html_e( 'Buy Pro', 'fashion-designer' ); ?>
			</a>
		</div>
		<div  id="bwp_getstart" class="tabcontent">
			<div class="row">
				<div class="col-md-5 intro">
					<div class="pad-box">
						<h2><?php esc_html_e( 'Welcome to Fashion Designer ', 'fashion-designer' ); ?>
						<span><?php esc_html_e( 'Version: ', 'fashion-designer' ); ?><?php echo esc_html($fashion_designer_theme['Version']);?></span>
						</h2>
						<span class="intro__version"><?php esc_html_e( 'Congratulations! You are about to use the most easy to use and flexible WordPress theme.', 'fashion-designer' ); ?>
						</span>
						<div class="powered-by">
							
							<div class="demo-content">
								<?php
									/* Demo Import */
									require get_parent_theme_file_path( '/inc/getstarted/demo-content.php' );
								?>
							</div>
							<div id="demo-import-loader">
								<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstarted/images/spinner.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'fashion-designer'); ?>" />
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-7">
					<div class="install-plugins">
						<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstarted/images/responsive-free.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'fashion-designer'); ?>" />
					</div>
				</div>
			</div>
			<div class="dashboard__blocks">
				<div class="row">
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Get Support','fashion-designer'); ?></h3>
						<ol>
							<li><a target="_blank" href="<?php echo esc_url( FASHION_DESIGNER_SUPPORT ); ?>"><?php esc_html_e( 'Free Theme Support','fashion-designer'); ?></a></li>
							<li><a target="_blank" href="<?php echo esc_url( FASHION_DESIGNER_PRO_SUPPORT ); ?>"><?php esc_html_e( 'Premium Theme Support','fashion-designer'); ?></a></li>
						</ol>
					</div>
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Getting Started','fashion-designer'); ?></h3>
						<ol>
							<li><?php esc_html_e( 'Start','fashion-designer'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','fashion-designer'); ?></a> <?php esc_html_e( 'your website.','fashion-designer'); ?> </li>
						</ol>
					</div>
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Help Docs','fashion-designer'); ?></h3>
						<ol>
							<li><a target="_blank" href="<?php echo esc_url( FASHION_DESIGNER_FREE_THEME_DOC ); ?>"><?php esc_html_e( 'Free Theme Documentation','fashion-designer'); ?></a></li>
							<li><a target="_blank" href="<?php echo esc_url( FASHION_DESIGNER_PRO_DOC ); ?>"><?php esc_html_e( 'Premium Theme Documentation','fashion-designer'); ?></a></li>
						</ol>
					</div>
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Buy Premium','fashion-designer'); ?></h3>
						<ol>
							<a href="<?php echo esc_url( FASHION_DESIGNER_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'fashion-designer'); ?></a>
						</ol>
					</div>
				</div>
			</div>
		</div>
		<div  id="bwp_setup" class="tabcontent">
			<h2 class="tg-docs-section intruction-title" id="section-4"><?php esc_html_e( '1) Setup Fashion Designer Theme', 'fashion-designer' ); ?></h2>
			<div class="row">
				<div class="theme-instruction-block col-md-7">
					<div class="pad-box">
						<p><?php esc_html_e( 'Fashion designer is a theme of premium category solely crafted for the fashion designers or fashion stylists or people who are associated with the business related to fashion cosmetics, boutique, Shoe Line, kids season sale, Personal Stylist, Create Unique T-Shirts, Fashion Columnist, Design Sunglasses, costumier, Textile design, Fashion event producer, couturier, fabricator, tailor, hairdresser,Fashion, Design, Clothing, Boutique, Apparel, Winter cloths, christmas cloths, fashion enthusiasts, Expert fashion tips, Fashion streetwear, menswear, artist, jewelry, Rent Designer Clothes, Fashion Marketer, Fashion YouTuber, designer suit, Wedding cloths, Fashion Expos, luxury, sneakers, fashion street trends, bag, glasses, high-fashion, jeans, men clothing, Furniture stores, clothing brands, models, fashion projects, introducing your models, showcasing fashion brands Fashion & Apparel stores, Painters store, fashion product, Fashion Shop, fashion store, accessories, model agency. It is a multipurpose, minimal and elegant theme making it a preferable one for the make-up artists, online selling virtual products, online cloth selling, online jewelery shopping, beauty salon operators well as personal designers. Being sophisticated, retina ready and user-friendly and accompanied with testimonial section, personalization options and faster page load time plus Bootstrap and CTA, this WordPress theme of premium level is good for the cosmetic boutique business and for the makeup salon as well as hair stylists. Fashion Designer WordPress theme is social media and SEO friendly and apart from that, the theme is accompanied with optimised codes, footer widgets, clean codes and has the faster page load time. Fashion designer is also good for nail salon, visage salon, makeup studio, beauty blog, glamour and others. Since it is mobile friendly, responsive as well as translation ready with multiple languages like AR_ARABIC, DE_GERMAN, ES_SPANISH, FR_FRENCH, IT_ITALIAN, RU_RUSSIAN, ZH_CHINESE, TR_TURKISH, this wp theme can also be used to create blogs related to fashion, beauty, lifestyle, make up, gossip or food or journal blog and there is no requirement to write a single line of code. Fashion designer has the potential to create an exotic feminine fashion blog and is also a preferable one for bloggers, newspapers, writers or journalists.', 'fashion-designer' ); ?><p><br>
						<ol>
							<li><?php esc_html_e( 'Start','fashion-designer'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','fashion-designer'); ?></a> <?php esc_html_e( 'your website.','fashion-designer'); ?> </l>
							<li><?php esc_html_e( 'Fashion Designer','fashion-designer'); ?> <a target="_blank" href="<?php echo esc_url( FASHION_DESIGNER_FREE_THEME_DOC ); ?>"><?php esc_html_e( 'Documentation','fashion-designer'); ?></a> </li>
						</ol>
					</div>
				</div>
				<div class="col-md-5">
					<div class="pad-box">
							<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstarted/images/screenshot.png'); ?>"/>
					</div>
				</div>	
			</div>
		</div>
		<div class="col-md-12 text-block tabcontent"  id="bwp_premium_info">
			<h2 class="dashboard-install-title"><?php esc_html_e( '2) Premium Theme Information.','fashion-designer'); ?></h2>
			<div class="row">
				<div class="col-md-7">
					<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstarted/images/responsive-pro.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'fashion-designer'); ?>">
					<div class="pad-box">
						<h3><?php esc_html_e( 'Pro Theme Description','fashion-designer'); ?></h3>
						<p class="pad-box-p"><?php esc_html_e( 'Fashion designer WordPress theme is creative as well as sharp and is pliable and responsive making it a preferable choice for the fashion industry as well as fashion designers or the startups who want to excel in the fashion related business. With this theme, you are in a position to craft the websites of professional quality because of certain mind-blowing features like customization and personalization options, retina ready, Bootstrap, CTA, translation readiness, clean code, testimonial section and much more-all making this theme good for the makeup artists as well as personal designers. Fashion designer WP theme is good for cosmetics boutique, makeup salon, hairstylist, fashion blog, hairdresser, nail salon, visage salon, makeup studio, beauty blog, glamour, and others. Since this WP theme is clean and animated, it can be used to create fashion, lifestyle, beauty, makeup, gossip, food or a journal blog without writing a single line of code. Since it is luxurious with shortcodes, feminine fashion blog can be created as well.', 'fashion-designer' ); ?><p>
					</div>
				</div>
				<div class="col-md-5 install-plugin-right">
					<div class="pad-box">
						<h3><?php esc_html_e( 'Pro Theme Features','fashion-designer'); ?></h3>
						<div class="dashboard-install-benefit">
							<ul>
								<li><?php esc_html_e( 'One click demo importer','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Global color option','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Responsive design','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Favicon, logo, title, and tagline customization','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Advanced color options and color pallets','fashion-designer'); ?></li>
								<li><?php esc_html_e( '100+ font family options','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Simple menu option','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'SEO friendly','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Pagination option','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Compatible with different WordPress famous plugins like contact form 7','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Enable-Disable options on all sections','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Well sanitized as per WordPress standards.','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Responsive Layout for All Devices','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Footer customization options','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Fully integrated with the latest font awesome','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Background image option','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Custom Page Templates','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Allow To Set Site Title, Tagline, Logo','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Sticky post & comment threads','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Section reordering','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Customizable home page','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Footer widgets & editor style','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Social media feature','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Slider with unlimited number of slides','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Our Cleaning Services Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Testimonial Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Our Team Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Counter Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Our Project Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'How We Work Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Pricing Plan Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Brand Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Instagram Feed','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Newsletter Section','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Blog post section','fashion-designer'); ?></li>								
								<li><?php esc_html_e( 'Contact page template','fashion-designer'); ?></li>	
								<li><?php esc_html_e( 'Shortcodes for the Custom Posttype','fashion-designer'); ?></li>	
								<li><?php esc_html_e( 'Easily Customize WordPress Theme','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Change site title color','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Custom Widgets','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Advanced Theme Options','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Call to Action Buttons','fashion-designer'); ?></li>								
								<li><?php esc_html_e( 'Regular Updates','fashion-designer'); ?></li>	
								<li><?php esc_html_e( 'Full-width template','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Sidebar Widget Area','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Custom Google Fonts','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Custom Link Colors','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Home Page Sections','fashion-designer'); ?></li>
								<li><?php esc_html_e( 'Custom Sections','fashion-designer'); ?></li>								
								<li><?php esc_html_e( 'GPL Compatible','fashion-designer'); ?></li>	
								<li><?php esc_html_e( 'Excellent Core Web Vitals','fashion-designer'); ?></li>			
								<li><?php esc_html_e( 'Professional support','fashion-designer'); ?></li>	
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php } ?>