<div class="theme-offer">
	<?php 
        // Check if the demo import has been completed
        $fashion_designer_demo_import_completed = get_option('fashion_designer_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($fashion_designer_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'fashion-designer') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'fashion-designer') . '</a></span>';
        }

		//POST and update the customizer and other related data of POLITICAL CAMPAIGN
        if (isset($_POST['submit'])) {

            // Check if woocommerce is installed and activated
            if (!is_plugin_active('woocommerce/woocommerce.php')) {
              // Install the plugin if it doesn't exist
              $fashion_designer_plugin_slug = 'woocommerce';
              $fashion_designer_plugin_file = 'woocommerce/woocommerce.php';

              // Check if plugin is installed
              $fashion_designer_installed_plugins = get_plugins();
              if (!isset($fashion_designer_installed_plugins[$fashion_designer_plugin_file])) {
                  include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                  include_once(ABSPATH . 'wp-admin/includes/file.php');
                  include_once(ABSPATH . 'wp-admin/includes/misc.php');
                  include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                  // Install the plugin
                  $fashion_designer_upgrader = new Plugin_Upgrader();
                  $fashion_designer_upgrader->install('https://downloads.wordpress.org/plugin/woocommerce.latest-stable.zip');
              }
              // Activate the plugin
              activate_plugin($fashion_designer_plugin_file);
            }


            // ------- Create Nav Menu --------
            $fashion_designer_menuname = 'Main Menus';
            $fashion_designer_bpmenulocation = 'primary';
            $fashion_designer_menu_exists = wp_get_nav_menu_object($fashion_designer_menuname);

            if (!$fashion_designer_menu_exists) {
                $fashion_designer_menu_id = wp_create_nav_menu($fashion_designer_menuname);

                // Create Home Page
                $fashion_designer_home_title = 'Home';
                $fashion_designer_home = array(
                    'post_type' => 'page',
                    'post_title' => $fashion_designer_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $fashion_designer_home_id = wp_insert_post($fashion_designer_home);
                // Assign Home Page Template
                add_post_meta($fashion_designer_home_id, '_wp_page_template', 'page-template/custom-home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $fashion_designer_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($fashion_designer_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'fashion-designer'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $fashion_designer_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $fashion_designer_pages_title = 'Pages';
                $fashion_designer_pages_content = '
                <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>

                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                  All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $fashion_designer_pages = array(
                    'post_type' => 'page',
                    'post_title' => $fashion_designer_pages_title,
                    'post_content' => $fashion_designer_pages_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'pages'
                );
                $fashion_designer_pages_id = wp_insert_post($fashion_designer_pages);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($fashion_designer_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'fashion-designer'),
                    'menu-item-classes' => 'pages',
                    'menu-item-url' => home_url('/pages/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $fashion_designer_pages_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create About Us Page with Dummy Content
                $fashion_designer_about_title = 'About Us';
                $fashion_designer_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $fashion_designer_about = array(
                    'post_type' => 'page',
                    'post_title' => $fashion_designer_about_title,
                    'post_content' => $fashion_designer_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $fashion_designer_about_id = wp_insert_post($fashion_designer_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($fashion_designer_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'fashion-designer'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $fashion_designer_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Set the menu location if it's not already set
                if (!has_nav_menu($fashion_designer_bpmenulocation)) {
                    $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($locations)) {
                        $locations = array();
                    }
                    $locations[$fashion_designer_bpmenulocation] = $fashion_designer_menu_id;
                    set_theme_mod('nav_menu_locations', $locations);
                }
                
        }

           
            // Set the demo import completion flag
    		update_option('fashion_designer_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'fashion-designer') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'fashion-designer') . '</a></span>';
            //end 


            // Top Bar //
            set_theme_mod( 'fashion_designer_search_icon', 'fas fa-search' );  
            set_theme_mod( 'fashion_designer_search_close_icon', 'fa fa-window-close' ); 
            set_theme_mod( 'fashion_designer_search_placeholder', 'search' );   

            set_theme_mod( 'fashion_designer_call_icon', 'fas fa-phone' );  
            set_theme_mod( 'fashion_designer_call_text', 'PHONE' );  
            set_theme_mod( 'fashion_designer_call', '+00 1234 567 890' );  
            set_theme_mod( 'fashion_designer_email_icon', 'fas fa-envelope' );  
            set_theme_mod( 'fashion_designer_email_text', 'MAIL' );  
            set_theme_mod( 'fashion_designer_email', 'example@gmail.com' );  
            set_theme_mod( 'fashion_designer_cart_icon', 'fas fa-shopping-basket' );              


            // slider section start // 
            set_theme_mod( 'fashion_designer_slider_small_title', 'Te obtinuit ut adepto satis somno Aliisque' );
            set_theme_mod( 'fashion_designer_slider_button_text', 'Read More' );
            set_theme_mod( 'fashion_designer_slider_button_link', '#' );
            
            for($fashion_designer_i=1;$fashion_designer_i<=3;$fashion_designer_i++){
               $fashion_designer_slider_title = 'TE OBTINUIT UT ADEPTO';
               
                  // Create post object
               $my_post = array(
               'post_title'    => wp_strip_all_tags( $fashion_designer_slider_title ),
               'post_status'   => 'publish',
               'post_type'     => 'page',
               );

               // Insert the post into the database
               $fashion_designer_post_id = wp_insert_post( $my_post );

               if ($fashion_designer_post_id) {
                 // Set the theme mod for the slider page
                 set_theme_mod('fashion_designer_slider_page' . $fashion_designer_i, $fashion_designer_post_id);

                  $fashion_designer_image_url = get_template_directory_uri().'/assets/images/slider'.$fashion_designer_i.'.png';

                $fashion_designer_image_id = media_sideload_image($fashion_designer_image_url, $fashion_designer_post_id, null, 'id');

                    if (!is_wp_error($fashion_designer_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($fashion_designer_post_id, $fashion_designer_image_id);
                    }
                }
            }    
            

            // Fashion Categroy Section //
            set_theme_mod( 'fashion_designer_category_icon', 'fas fa-long-arrow-alt-right' );
            set_theme_mod('fashion_designer_category', 'collection');

            // Define post category names and post titles
            $fashion_designer_category_names = array('collection', 'postcategory2', 'postcategory3', 'postcategory4');
            $fashion_designer_title_array = array(
                array("CATEGORY TITLE 1", "CATEGORY TITLE 2", "CATEGORY TITLE 3","CATEGORY TITLE 4", "CATEGORY TITLE 5", "CATEGORY TITLE 6"),
                array("CATEGORY TITLE 1", "CATEGORY TITLE 2", "CATEGORY TITLE 3","CATEGORY TITLE 4", "CATEGORY TITLE 5", "CATEGORY TITLE 6"),
                array("CATEGORY TITLE 1", "CATEGORY TITLE 2", "CATEGORY TITLE 3","CATEGORY TITLE 4", "CATEGORY TITLE 5", "CATEGORY TITLE 6"),
                array("CATEGORY TITLE 1", "CATEGORY TITLE 2", "CATEGORY TITLE 3","CATEGORY TITLE 4", "CATEGORY TITLE 5", "CATEGORY TITLE 6")
            );

            foreach ($fashion_designer_category_names as $fashion_designer_index => $fashion_designer_category_name) {
                // Create or retrieve the post category term ID
                $fashion_designer_term = term_exists($fashion_designer_category_name, 'category');
                if ($fashion_designer_term === 0 || $fashion_designer_term === null) {
                    // If the term does not exist, create it
                    $fashion_designer_term = wp_insert_term($fashion_designer_category_name, 'category');
                }
                if (is_wp_error($fashion_designer_term)) {
                    error_log('Error creating category: ' . $fashion_designer_term->get_error_message());
                    continue; // Skip to the next iteration if category creation fails
                }

                for ($fashion_designer_i = 0; $fashion_designer_i < 6; $fashion_designer_i++) {
                    // Create post content
                    $fashion_designer_title = $fashion_designer_title_array[$fashion_designer_index][$fashion_designer_i];
                    $fashion_designer_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s.';

                    // Create post post object
                    $fashion_designer_my_post = array(
                        'post_title'    => wp_strip_all_tags($fashion_designer_title),
                        'post_content'  => $fashion_designer_content,
                        'post_status'   => 'publish',
                        'post_type'     => 'post', // Post type set to 'post'
                    );

                    // Insert the post into the database
                    $fashion_designer_post_id = wp_insert_post($fashion_designer_my_post);

                    if (is_wp_error($fashion_designer_post_id)) {
                        error_log('Error creating post: ' . $fashion_designer_post_id->get_error_message());
                        continue; // Skip to the next post if creation fails
                    }

                    // Assign the category to the post
                    wp_set_post_categories($fashion_designer_post_id, array((int)$fashion_designer_term['term_id']));

                    // Handle the featured image using media_sideload_image
                    $fashion_designer_image_url = get_template_directory_uri() . '/inc/block-patterns/images/cat-image' . ($fashion_designer_i + 1) . '.png';
                    $fashion_designer_image_id = media_sideload_image($fashion_designer_image_url, $fashion_designer_post_id, null, 'id');

                    if (is_wp_error($fashion_designer_image_id)) {
                        error_log('Error downloading image: ' . $fashion_designer_image_id->get_error_message());
                        continue; // Skip to the next post if image download fails
                    }
                    // Assign featured image to post
                    set_post_thumbnail($fashion_designer_post_id, $fashion_designer_image_id);
                }
            }   
            //Copyright Text
            set_theme_mod( 'fashion_designer_footer_text', 'By VWThemes' );  
     
        }
    ?>
  
	
    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=fashion_designer_guide" method="POST" onsubmit="return validate(this);">
    <?php if (!get_option('fashion_designer_demo_import_completed')) : ?>
        <form method="post">
            <p class="run-import-text"><?php esc_html_e('Click On The Below Run Importer Button To Import Demo Content Of Fashion Designer','fashion-designer'); ?></p>
            <p><?php esc_html_e('Please back up your website if it’s already live with data. This importer will overwrite your existing settings with the new customizer values for Fashion Designer','fashion-designer'); ?></p>
            <input class= "run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer','fashion-designer'); ?>" class="button button-primary button-large">
        </form>
    <?php endif; ?>
    </form>
	<script type="text/javascript">
		function validate(valid) {
			 if(confirm("Do you really want to import the theme demo content?")){
                // Show loader
                document.getElementById('demo-import-loader').style.display = 'block';
                // Submit form
			    document.forms[0].submit();
			}
		    else {
			    return false;
		    }
		}
	</script>
</div>

