<?php
/**
 * Fashion Designer Theme Customizer
 *
 * @package Fashion Designer
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function fashion_designer_custom_controls() {
	load_template( trailingslashit( get_template_directory() ) . '/inc/custom-controls.php' );
}
add_action( 'customize_register', 'fashion_designer_custom_controls' );

function fashion_designer_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-picker.php' );

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage'; 
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'blogname', array( 
		'selector' => '.logo .site-title a', 
	 	'render_callback' => 'fashion_designer_customize_partial_blogname', 
	)); 

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array( 
		'selector' => 'p.site-description', 
		'render_callback' => 'fashion_designer_customize_partial_blogdescription', 
	));

	//add home page setting pannel
	$FashionDesignerParentPanel = new Fashion_Designer_WP_Customize_Panel( $wp_customize, 'fashion_designer_panel_id', array(
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__( 'VW Settings', 'fashion-designer' ),
		'priority' => 10,
	));

	$wp_customize->add_panel( $FashionDesignerParentPanel );

	$HomePageParentPanel = new Fashion_Designer_WP_Customize_Panel( $wp_customize, 'fashion_designer_homepage_panel', array(
		'title' => __( 'Homepage Settings', 'fashion-designer' ),
		'panel' => 'fashion_designer_panel_id',
	));

	$wp_customize->add_panel( $HomePageParentPanel );

	//Top Bar
	$wp_customize->add_section( 'fashion_designer_topbar', array(
    	'title'      => __( 'Top Bar Settings', 'fashion-designer' ),
		'panel' => 'fashion_designer_homepage_panel'
	) );

   	// Header Background color
	$wp_customize->add_setting('fashion_designer_header_background_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_header_background_color', array(
		'label'    => __('Header Background Color', 'fashion-designer'),
		'section'  => 'header_image',
	)));

	$wp_customize->add_setting('fashion_designer_header_img_position',array(
	  'default' => 'center top',
	  'transport' => 'refresh',
	  'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_header_img_position',array(
		'type' => 'select',
		'label' => __('Header Image Position','fashion-designer'),
		'section' => 'header_image',
		'choices' 	=> array(
			'left top' 		=> esc_html__( 'Top Left', 'fashion-designer' ),
			'center top'   => esc_html__( 'Top', 'fashion-designer' ),
			'right top'   => esc_html__( 'Top Right', 'fashion-designer' ),
			'left center'   => esc_html__( 'Left', 'fashion-designer' ),
			'center center'   => esc_html__( 'Center', 'fashion-designer' ),
			'right center'   => esc_html__( 'Right', 'fashion-designer' ),
			'left bottom'   => esc_html__( 'Bottom Left', 'fashion-designer' ),
			'center bottom'   => esc_html__( 'Bottom', 'fashion-designer' ),
			'right bottom'   => esc_html__( 'Bottom Right', 'fashion-designer' ),
		),
	));

	//Sticky Header
	$wp_customize->add_setting( 'fashion_designer_sticky_header',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_sticky_header',array(
        'label' => esc_html__( 'Show / Hide Sticky Header','fashion-designer' ),
        'section' => 'fashion_designer_topbar'
    )));

    $wp_customize->add_setting( 'fashion_designer_hide_show_topbar_section',array(
	  	'default' => 1,
	  	'transport' => 'refresh',
	  	'sanitize_callback' => 'fashion_designer_switch_sanitization'
  	));
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_hide_show_topbar_section',array(
	  	'label' => esc_html__( 'Show / Hide Topbar','fashion-designer' ),
	  	'section' => 'fashion_designer_topbar',
 	)));

    $wp_customize->add_setting('fashion_designer_sticky_header_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_sticky_header_padding',array(
		'label'	=> __('Sticky Header Padding','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_topbar',
		'type'=> 'text'
	));

    $wp_customize->add_setting( 'fashion_designer_header_search',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_header_search',array(
      	'label' => esc_html__( 'Show / Hide Search','fashion-designer' ),
      	'section' => 'fashion_designer_topbar'
    )));

    $wp_customize->add_setting('fashion_designer_search_icon',array(
		'default'	=> 'fas fa-search',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_search_icon',array(
		'label'	=> __('Add Search Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_topbar',
		'setting'	=> 'fashion_designer_search_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('fashion_designer_search_close_icon',array(
		'default'	=> 'fa fa-window-close',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_search_close_icon',array(
		'label'	=> __('Add Search Close Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_topbar',
		'setting'	=> 'fashion_designer_search_close_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('fashion_designer_search_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_search_font_size',array(
		'label'	=> __('Search Font Size','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_search_placeholder',array(
       'default' => esc_html__('Search','fashion-designer'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('fashion_designer_search_placeholder',array(
       'type' => 'text',
       'label' => __('Search Placeholder Text','fashion-designer'),
       'section' => 'fashion_designer_topbar'
    ));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('fashion_designer_call', array( 
		'selector' => '.info-ctr p', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_call', 
	));

    $wp_customize->add_setting('fashion_designer_call_icon',array(
		'default'	=> 'fas fa-phone',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_call_icon',array(
		'label'	=> __('Add Phone Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_topbar',
		'setting'	=> 'fashion_designer_call_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('fashion_designer_call_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_call_text',array(
		'label'	=> __('Add Phone Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'PHONE', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_call',array(
		'default'=> '',
		'sanitize_callback'	=> 'fashion_designer_sanitize_phone_number'
	));
	$wp_customize->add_control('fashion_designer_call',array(
		'label'	=> __('Add Phone Number','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '+00 1234 567 890', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_email_icon',array(
		'default'	=> 'fas fa-envelope',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_email_icon',array(
		'label'	=> __('Add Email Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_topbar',
		'setting'	=> 'fashion_designer_email_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('fashion_designer_email_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_email_text',array(
		'label'	=> __('Add Email Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'MAIL', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_email',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));
	$wp_customize->add_control('fashion_designer_email',array(
		'label'	=> __('Add Email Address','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'example@gmail.com', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_cart_icon',array(
		'default'	=> 'fas fa-shopping-basket',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_cart_icon',array(
		'label'	=> __('Add Cart Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_topbar',
		'setting'	=> 'fashion_designer_cart_icon',
		'type'		=> 'icon'
	)));

	//Menus Settings
	$wp_customize->add_section( 'fashion_designer_menu_section' , array(
    	'title' => __( 'Menus Settings', 'fashion-designer' ),
		'panel' => 'fashion_designer_homepage_panel'
	) );

	$wp_customize->add_setting('fashion_designer_navigation_menu_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_navigation_menu_font_size',array(
		'label'	=> __('Menus Font Size','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_menu_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_navigation_menu_font_weight',array(
        'default' => 600,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_navigation_menu_font_weight',array(
        'type' => 'select',
        'label' => __('Menus Font Weight','fashion-designer'),
        'section' => 'fashion_designer_menu_section',
        'choices' => array(
        	'100' => __('100','fashion-designer'),
            '200' => __('200','fashion-designer'),
            '300' => __('300','fashion-designer'),
            '400' => __('400','fashion-designer'),
            '500' => __('500','fashion-designer'),
            '600' => __('600','fashion-designer'),
            '700' => __('700','fashion-designer'),
            '800' => __('800','fashion-designer'),
            '900' => __('900','fashion-designer'),
        ),
	) );

	// text trasform
	$wp_customize->add_setting('fashion_designer_menu_text_transform',array(
		'default'=> 'Capitalize',
		'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_menu_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Menus Text Transform','fashion-designer'),
		'choices' => array(
            'Uppercase' => __('Uppercase','fashion-designer'),
            'Capitalize' => __('Capitalize','fashion-designer'),
            'Lowercase' => __('Lowercase','fashion-designer'),
        ),
		'section'=> 'fashion_designer_menu_section',
	));

	$wp_customize->add_setting('fashion_designer_menus_item_style',array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_menus_item_style',array(
        'type' => 'select',
        'section' => 'fashion_designer_menu_section',
		'label' => __('Menu Item Hover Style','fashion-designer'),
		'choices' => array(
            'None' => __('None','fashion-designer'),
            'Zoom In' => __('Zoom In','fashion-designer'),
        ),
	) );

	$wp_customize->add_setting('fashion_designer_header_menus_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_header_menus_color', array(
		'label'    => __('Menus Color', 'fashion-designer'),
		'section'  => 'fashion_designer_menu_section',
	)));

	$wp_customize->add_setting('fashion_designer_header_menus_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_header_menus_hover_color', array(
		'label'    => __('Menus Hover Color', 'fashion-designer'),
		'section'  => 'fashion_designer_menu_section',
	)));

	$wp_customize->add_setting('fashion_designer_header_submenus_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_header_submenus_color', array(
		'label'    => __('Sub Menus Color', 'fashion-designer'),
		'section'  => 'fashion_designer_menu_section',
	)));

	$wp_customize->add_setting('fashion_designer_header_submenus_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_header_submenus_hover_color', array(
		'label'    => __('Sub Menus Hover Color', 'fashion-designer'),
		'section'  => 'fashion_designer_menu_section',
	)));
    
	//Slider
	$wp_customize->add_section( 'fashion_designer_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'fashion-designer' ),
    	'description' => __('Free theme has 3 slides options, For unlimited slides and more options </br> <a class="go-pro-btn" target="blank" href="https://www.buywptemplates.com/products/fashion-designer-wordpress-theme">GET PRO</a>','fashion-designer'),
		'panel' => 'fashion_designer_homepage_panel'
	) );

	$wp_customize->add_setting( 'fashion_designer_slider_arrows',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_slider_arrows',array(
      	'label' => esc_html__( 'Show / Hide Slider','fashion-designer' ),
      	'section' => 'fashion_designer_slidersettings'
    )));

    $wp_customize->add_setting('fashion_designer_slider_type',array(
        'default' => 'Default slider',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	) );
	$wp_customize->add_control('fashion_designer_slider_type', array(
        'type' => 'select',
        'label' => __('Slider Type','fashion-designer'),
        'section' => 'fashion_designer_slidersettings',
        'choices' => array(
            'Default slider' => __('Default slider','fashion-designer'),
            'Advance slider' => __('Advance slider','fashion-designer'),
        ),
	));

	$wp_customize->add_setting('fashion_designer_advance_slider_shortcode',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_advance_slider_shortcode',array(
		'label'	=> __('Add Slider Shortcode','fashion-designer'),
		'section'=> 'fashion_designer_slidersettings',
		'type'=> 'text',
		'active_callback' => 'fashion_designer_advance_slider'
	));

    //Selective Refresh
    $wp_customize->selective_refresh->add_partial('fashion_designer_slider_arrows',array(
		'selector'        => '#slider .inner_carousel h1',
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_slider_arrows',
	));

	for ( $count = 1; $count <= 3; $count++ ) {
		$wp_customize->add_setting( 'fashion_designer_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'fashion_designer_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'fashion_designer_slider_page' . $count, array(
			'label'    => __( 'Select Slider Page', 'fashion-designer' ),
			'description' => __('Slider image size (1600 x 700)','fashion-designer'),
			'section'  => 'fashion_designer_slidersettings',
			'type'     => 'dropdown-pages',
			'active_callback' => 'fashion_designer_default_slider'
		) );
	}

	$wp_customize->add_setting( 'fashion_designer_slider_small_title', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field'
    ) );
    $wp_customize->add_control( 'fashion_designer_slider_small_title', array(
        'label'    => __( 'Add Slider Small Text', 'fashion-designer' ),
        'input_attrs' => array(
            'placeholder' => __( 'TE OBTINUIT UT ADEPTO', 'fashion-designer' ),
        ),
        'section'  => 'fashion_designer_slidersettings',
        'type'     => 'text',
        'active_callback' => 'fashion_designer_default_slider'
    ) );

	$wp_customize->add_setting('fashion_designer_slider_button_text',array(
		'default'=> 'Read More',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_slider_button_text',array(
		'label'	=> __('Add Slider Button Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Read More', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_slidersettings',
		'type'=> 'text',
		'active_callback' => 'fashion_designer_default_slider'
	));

	$wp_customize->add_setting('fashion_designer_slider_button_link',array(
        'default'=> '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('fashion_designer_slider_button_link',array(
        'label' => esc_html__('Add Button Link','fashion-designer'),
        'input_attrs' => array(
            'placeholder' => esc_html__( 'www.example-info.com', 'fashion-designer' ),
        ),
        'section'=> 'fashion_designer_slidersettings',
        'type'=> 'url'
    ));

	$wp_customize->add_setting( 'fashion_designer_slider_title_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_slider_title_hide_show',array(
		'label' => esc_html__( 'Show / Hide Slider Title','fashion-designer' ),
		'section' => 'fashion_designer_slidersettings',
		'active_callback' => 'fashion_designer_default_slider'
    )));

	//content layout
	$wp_customize->add_setting('fashion_designer_slider_content_option',array(
        'default' => 'Center',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control(new Fashion_Designer_Image_Radio_Control($wp_customize, 'fashion_designer_slider_content_option', array(
        'type' => 'select',
        'label' => __('Slider Content Layouts','fashion-designer'),
        'section' => 'fashion_designer_slidersettings',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/slider-content1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/slider-content2.png',
            'Right' => esc_url(get_template_directory_uri()).'/assets/images/slider-content3.png',
    ),
    	'active_callback' => 'fashion_designer_default_slider'
    )));

    //Slider content padding
    $wp_customize->add_setting('fashion_designer_slider_content_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_slider_content_padding_top_bottom',array(
		'label'	=> __('Slider Content Padding Top Bottom','fashion-designer'),
		'description'	=> __('Enter a value in %. Example:20%','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '50%', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_slidersettings',
		'type'=> 'text',
		'active_callback' => 'fashion_designer_default_slider'
	));

	$wp_customize->add_setting('fashion_designer_slider_content_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_slider_content_padding_left_right',array(
		'label'	=> __('Slider Content Padding Left Right','fashion-designer'),
		'description'	=> __('Enter a value in %. Example:20%','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '50%', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_slidersettings',
		'type'=> 'text',
		'active_callback' => 'fashion_designer_default_slider'
	));

	//Opacity
	$wp_customize->add_setting('fashion_designer_slider_opacity_color',array(
      'default'              => 0.4,
      'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));

	$wp_customize->add_control( 'fashion_designer_slider_opacity_color', array(
	'label'       => esc_html__( 'Slider Image Opacity','fashion-designer' ),
	'section'     => 'fashion_designer_slidersettings',
	'type'        => 'select',
	'settings'    => 'fashion_designer_slider_opacity_color',
	'choices' => array(
      '0' =>  esc_attr( __('0','fashion-designer')),
      '0.1' =>  esc_attr( __('0.1','fashion-designer')),
      '0.2' =>  esc_attr( __('0.2','fashion-designer')),
      '0.3' =>  esc_attr( __('0.3','fashion-designer')),
      '0.4' =>  esc_attr( __('0.4','fashion-designer')),
      '0.5' =>  esc_attr( __('0.5','fashion-designer')),
      '0.6' =>  esc_attr( __('0.6','fashion-designer')),
      '0.7' =>  esc_attr( __('0.7','fashion-designer')),
      '0.8' =>  esc_attr( __('0.8','fashion-designer')),
      '0.9' =>  esc_attr( __('0.9','fashion-designer'))
	),'active_callback' => 'fashion_designer_default_slider'
	));

	$wp_customize->add_setting( 'fashion_designer_slider_image_overlay',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'fashion_designer_switch_sanitization'
   ));
   $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_slider_image_overlay',array(
      	'label' => esc_html__( 'Show / Hide Slider Image Overlay','fashion-designer' ),
      	'section' => 'fashion_designer_slidersettings',
      	'active_callback' => 'fashion_designer_default_slider'
   )));

   $wp_customize->add_setting('fashion_designer_slider_image_overlay_color', array(
		'default'           => '#1b1a18',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_slider_image_overlay_color', array(
		'label'    => __('Slider Image Overlay Color', 'fashion-designer'),
		'section'  => 'fashion_designer_slidersettings',
		'active_callback' => 'fashion_designer_default_slider'
	)));

	//Slider height
	$wp_customize->add_setting('fashion_designer_slider_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_slider_height',array(
		'label'	=> __('Slider Height','fashion-designer'),
		'description'	=> __('Specify the slider height (px).','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '500px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_slidersettings',
		'type'=> 'text',
		'active_callback' => 'fashion_designer_default_slider'
	));

	$wp_customize->add_setting( 'fashion_designer_slider_speed', array(
		'default'  => 4000,
		'sanitize_callback'	=> 'fashion_designer_sanitize_float'
	) );
	$wp_customize->add_control( 'fashion_designer_slider_speed', array(
		'label' => esc_html__('Slider Transition Speed','fashion-designer'),
		'section' => 'fashion_designer_slidersettings',
		'type'  => 'number',
		'active_callback' => 'fashion_designer_default_slider'
	) );
 
	//Fashion Categroy
	$wp_customize->add_section('fashion_designer_category_section',array(
		'title'	=> __('Fashion Categroy Section','fashion-designer'),
		'description' => __('For more options of category section </br><a class="go-pro-btn" target="blank" href="https://www.buywptemplates.com/products/fashion-designer-wordpress-theme">GET PRO</a>','fashion-designer'),
		'panel' => 'fashion_designer_homepage_panel',
	));	

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'fashion_designer_category', array( 
		'selector' => '.box-content h2', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_category',
	));

	$categories = get_categories();
		$cat_posts = array();
			$i = 0;
			$cat_posts[]='Select';	
		foreach($categories as $category){
			if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_posts[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('fashion_designer_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('fashion_designer_category',array(
		'type'    => 'select',
		'choices' => $cat_posts,
		'label' => __('Select Category to display Latest Post','fashion-designer'),
		'description'=> __('Size of image should be 370 x 270 ','fashion-designer'),
		'section' => 'fashion_designer_category_section',
	));

	$wp_customize->add_setting('fashion_designer_category_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-right',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_category_icon',array(
		'label'	=> __('Add Category Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_category_section',
		'setting'	=> 'fashion_designer_category_icon',
		'type'		=> 'icon'
	)));

	//features Section
	$wp_customize->add_section('fashion_designer_features', array(
		'title'       => __('Features Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_features_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_features_text',array(
		'description' => __('<p>1. More options for features section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for features section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_features',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_features_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_features_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_features',
		'type'=> 'hidden'
	));

	//services Section
	$wp_customize->add_section('fashion_designer_services', array(
		'title'       => __('Services Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme services</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_services_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_services_text',array(
		'description' => __('<p>1. More options for services section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for services section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_services',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_services_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_services_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_services',
		'type'=> 'hidden'
	));

	//about us Section
	$wp_customize->add_section('fashion_designer_about_us', array(
		'title'       => __('About Us Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme about_us</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_about_us_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_about_us_text',array(
		'description' => __('<p>1. More options for about us section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for about us section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_about_us',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_about_us_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_about_us_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_about_us',
		'type'=> 'hidden'
	));

	//records Section
	$wp_customize->add_section('fashion_designer_records', array(
		'title'       => __('Records Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme records</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_records_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_records_text',array(
		'description' => __('<p>1. More options for records section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for records section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_records',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_records_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_records_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_records',
		'type'=> 'hidden'
	));

	//projects Section
	$wp_customize->add_section('fashion_designer_projects', array(
		'title'       => __('Projects Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme projects</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_projects_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_projects_text',array(
		'description' => __('<p>1. More options for projects section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for projects section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_projects',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_projects_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_projects_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_projects',
		'type'=> 'hidden'
	));

	//products Section
	$wp_customize->add_section('fashion_designer_products', array(
		'title'       => __('Products Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme products</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_products_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_products_text',array(
		'description' => __('<p>1. More options for products section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for products section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_products',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_products_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_products_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_products',
		'type'=> 'hidden'
	));

	//video Section
	$wp_customize->add_section('fashion_designer_video', array(
		'title'       => __('Video Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme video</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_video_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_video_text',array(
		'description' => __('<p>1. More options for video section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for video section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_video',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_video_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_video_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_video',
		'type'=> 'hidden'
	));

	//pricing plan Section
	$wp_customize->add_section('fashion_designer_pricing_plan', array(
		'title'       => __('Pricing Plan Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme pricing_plan</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_pricing_plan_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_pricing_plan_text',array(
		'description' => __('<p>1. More options for pricing plan section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for pricing plan section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_pricing_plan',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_pricing_plan_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_pricing_plan_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_pricing_plan',
		'type'=> 'hidden'
	));

	//our team Section
	$wp_customize->add_section('fashion_designer_our_team', array(
		'title'       => __('Our Team Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme our_team</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_our_team_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_our_team_text',array(
		'description' => __('<p>1. More options for our team section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for our team section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_our_team',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_our_team_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_our_team_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_our_team',
		'type'=> 'hidden'
	));

	//testimonial Section
	$wp_customize->add_section('fashion_designer_testimonial', array(
		'title'       => __('Testimonial Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme testimonial</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_testimonial_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_testimonial_text',array(
		'description' => __('<p>1. More options for testimonial section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for testimonial section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_testimonial',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_testimonial_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_testimonial_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_testimonial',
		'type'=> 'hidden'
	));



	//blogs Section
	$wp_customize->add_section('fashion_designer_blogs', array(
		'title'       => __('Blogs Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme blogs</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_blogs_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_blogs_text',array(
		'description' => __('<p>1. More options for blogs section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for blogs section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_blogs',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_blogs_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_blogs_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_blogs',
		'type'=> 'hidden'
	));

	//newsletter Section
	$wp_customize->add_section('fashion_designer_newsletter', array(
		'title'       => __('Newsletter Section', 'fashion-designer'),
		'description' => __('<p class="premium-opt">Premium Theme newsletter</p>','fashion-designer'),
		'priority'    => null,
		'panel'       => 'fashion_designer_homepage_panel',
	));

	$wp_customize->add_setting('fashion_designer_newsletter_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_newsletter_text',array(
		'description' => __('<p>1. More options for newsletter section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for newsletter section.</p>','fashion-designer'),
		'section'=> 'fashion_designer_newsletter',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('fashion_designer_newsletter_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_newsletter_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(FASHION_DESIGNER_BUY_NOW).">More Info</a>",
		'section'=> 'fashion_designer_newsletter',
		'type'=> 'hidden'
	));

	//Footer Text
	$wp_customize->add_section('fashion_designer_footer',array(
		'title'	=> __('Footer Settings','fashion-designer'),
		'description' => __('For more options of footer section </br><a class="go-pro-btn" target="blank" href="https://www.buywptemplates.com/products/fashion-designer-wordpress-theme">GET PRO</a>','fashion-designer'),
		'panel' => 'fashion_designer_homepage_panel',
	));	

	$wp_customize->add_setting( 'fashion_designer_footer_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_footer_hide_show',array(
      'label' => esc_html__( 'Show / Hide Footer','fashion-designer' ),
      'section' => 'fashion_designer_footer'
    )));

    	// font size
	$wp_customize->add_setting('fashion_designer_button_footer_font_size',array(
		'default'=> 30,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_button_footer_font_size',array(
		'label'	=> __('Footer Heading Font Size','fashion-designer'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'fashion_designer_footer',
	));

	$wp_customize->add_setting('fashion_designer_button_footer_heading_letter_spacing',array(
		'default'=> 1,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_button_footer_heading_letter_spacing',array(
		'label'	=> __('Heading Letter Spacing','fashion-designer'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
	),
		'section'=> 'fashion_designer_footer',
	));

	// text trasform
	$wp_customize->add_setting('fashion_designer_button_footer_text_transform',array(
		'default'=> 'Capitalize',
		'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_button_footer_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Heading Text Transform','fashion-designer'),
		'choices' => array(
      'Uppercase' => __('Uppercase','fashion-designer'),
      'Capitalize' => __('Capitalize','fashion-designer'),
      'Lowercase' => __('Lowercase','fashion-designer'),
    ),
		'section'=> 'fashion_designer_footer',
	));

	$wp_customize->add_setting('fashion_designer_footer_heading_weight',array(
        'default' => 600,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_footer_heading_weight',array(
        'type' => 'select',
        'label' => __('Heading Font Weight','fashion-designer'),
        'section' => 'fashion_designer_footer',
        'choices' => array(
        	'100' => __('100','fashion-designer'),
            '200' => __('200','fashion-designer'),
            '300' => __('300','fashion-designer'),
            '400' => __('400','fashion-designer'),
            '500' => __('500','fashion-designer'),
            '600' => __('600','fashion-designer'),
            '700' => __('700','fashion-designer'),
            '800' => __('800','fashion-designer'),
            '900' => __('900','fashion-designer'),
        ),
	) );

	$wp_customize->add_setting('fashion_designer_footer_template',array(
	  'default'	=> esc_html('fashion_designer-footer-one'),
	  'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_footer_template',array(
	      'label'	=> esc_html__('Footer style','fashion-designer'),
	      'section'	=> 'fashion_designer_footer',
	      'setting'	=> 'fashion_designer_footer_template',
	      'type' => 'select',
	      'choices' => array(
	          'fashion_designer-footer-one' => esc_html__('Style 1', 'fashion-designer'),
	          'fashion_designer-footer-two' => esc_html__('Style 2', 'fashion-designer'),
	          'fashion_designer-footer-three' => esc_html__('Style 3', 'fashion-designer'),
	          'fashion_designer-footer-four' => esc_html__('Style 4', 'fashion-designer'),
	          'fashion_designer-footer-five' => esc_html__('Style 5', 'fashion-designer'),
	          )
	));

	$wp_customize->add_setting('fashion_designer_footer_background_color', array(
		'default'           => '#1b1a18',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_footer_background_color', array(
		'label'    => __('Footer Background Color', 'fashion-designer'),
		'section'  => 'fashion_designer_footer',
	)));

	$wp_customize->add_setting('fashion_designer_footer_background_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'fashion_designer_footer_background_image',array(
        'label' => __('Footer Background Image','fashion-designer'),
        'section' => 'fashion_designer_footer'
	)));

	$wp_customize->add_setting('fashion_designer_footer_img_position',array(
	  'default' => 'center center',
	  'transport' => 'refresh',
	  'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','fashion-designer'),
		'section' => 'fashion_designer_footer',
		'choices' 	=> array(
			'left top' 		=> esc_html__( 'Top Left', 'fashion-designer' ),
			'center top'   => esc_html__( 'Top', 'fashion-designer' ),
			'right top'   => esc_html__( 'Top Right', 'fashion-designer' ),
			'left center'   => esc_html__( 'Left', 'fashion-designer' ),
			'center center'   => esc_html__( 'Center', 'fashion-designer' ),
			'right center'   => esc_html__( 'Right', 'fashion-designer' ),
			'left bottom'   => esc_html__( 'Bottom Left', 'fashion-designer' ),
			'center bottom'   => esc_html__( 'Bottom', 'fashion-designer' ),
			'right bottom'   => esc_html__( 'Bottom Right', 'fashion-designer' ),
		),
	));

	// Footer
	$wp_customize->add_setting('fashion_designer_img_footer',array(
		'default'=> 'scroll',
		'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_img_footer',array(
		'type' => 'select',
		'label'	=> __('Footer Background Attatchment','fashion-designer'),
		'choices' => array(
            'fixed' => __('fixed','fashion-designer'),
            'scroll' => __('scroll','fashion-designer'),
        ),
		'section'=> 'fashion_designer_footer',
	));

	// footer padding
	$wp_customize->add_setting('fashion_designer_footer_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_footer_padding',array(
		'label'	=> __('Footer Top Bottom Padding','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
      'placeholder' => __( '10px', 'fashion-designer' ),
    ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_footer_widgets_heading',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_footer_widgets_heading',array(
        'type' => 'select',
        'label' => __('Footer Widget Heading','fashion-designer'),
        'section' => 'fashion_designer_footer',
        'choices' => array(
        	'Left' => __('Left','fashion-designer'),
            'Center' => __('Center','fashion-designer'),
            'Right' => __('Right','fashion-designer')
        ),
	) );

	$wp_customize->add_setting('fashion_designer_footer_widgets_content',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_footer_widgets_content',array(
        'type' => 'select',
        'label' => __('Footer Widget Content','fashion-designer'),
        'section' => 'fashion_designer_footer',
        'choices' => array(
        	'Left' => __('Left','fashion-designer'),
            'Center' => __('Center','fashion-designer'),
            'Right' => __('Right','fashion-designer')
        ),
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('fashion_designer_footer_text', array( 
		'selector' => '#footer-2 .copyright p', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_footer_text', 
	));

	$wp_customize->add_setting( 'fashion_designer_copyright_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_copyright_hide_show',array(
      'label' => esc_html__( 'Show / Hide Copyright','fashion-designer' ),
      'section' => 'fashion_designer_footer'
    )));

	$wp_customize->add_setting('fashion_designer_copyright_background_color', array(
		'default'           => '#d1b266',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_copyright_background_color', array(
		'label'    => __('Copyright Background Color', 'fashion-designer'),
		'section'  => 'fashion_designer_footer',
	)));
	
	$wp_customize->add_setting('fashion_designer_footer_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('fashion_designer_footer_text',array(
		'label'	=> __('Copyright Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Copyright 2019, .....', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));	

	$wp_customize->add_setting('fashion_designer_copyright_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_copyright_font_size',array(
		'label'	=> __('Copyright Font Size','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_copyright_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_copyright_padding_top_bottom',array(
		'label'	=> __('Copyright Padding Top Bottom','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_copyright_alingment',array(
        'default' => 'center',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control(new Fashion_Designer_Image_Radio_Control($wp_customize, 'fashion_designer_copyright_alingment', array(
        'type' => 'select',
        'label' => __('Copyright Alignment','fashion-designer'),
        'section' => 'fashion_designer_footer',
        'settings' => 'fashion_designer_copyright_alingment',
        'choices' => array(
            'left' => esc_url(get_template_directory_uri()).'/assets/images/copyright1.png',
            'center' => esc_url(get_template_directory_uri()).'/assets/images/copyright2.png',
            'right' => esc_url(get_template_directory_uri()).'/assets/images/copyright3.png'
    ))));

	$wp_customize->add_setting( 'fashion_designer_hide_show_scroll',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_hide_show_scroll',array(
      	'label' => esc_html__( 'Show / Hide Scroll To Top','fashion-designer' ),
      	'section' => 'fashion_designer_footer'
    )));

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial('fashion_designer_scroll_to_top_icon', array( 
		'selector' => '.scrollup i', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_scroll_to_top_icon', 
	));

    $wp_customize->add_setting('fashion_designer_scroll_to_top_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_scroll_to_top_icon',array(
		'label'	=> __('Add Scroll to Top Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_footer',
		'setting'	=> 'fashion_designer_scroll_to_top_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('fashion_designer_scroll_to_top_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_scroll_to_top_font_size',array(
		'label'	=> __('Icon Font Size','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_scroll_to_top_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_scroll_to_top_padding',array(
		'label'	=> __('Icon Top Bottom Padding','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_scroll_to_top_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_scroll_to_top_width',array(
		'label'	=> __('Icon Width','fashion-designer'),
		'description'	=> __('Enter a value in pixels Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_scroll_to_top_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_scroll_to_top_height',array(
		'label'	=> __('Icon Height','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fashion_designer_scroll_to_top_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_scroll_to_top_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_footer',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('fashion_designer_scroll_top_alignment',array(
        'default' => 'Right',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control(new Fashion_Designer_Image_Radio_Control($wp_customize, 'fashion_designer_scroll_top_alignment', array(
        'type' => 'select',
        'label' => __('Scroll To Top','fashion-designer'),
        'section' => 'fashion_designer_footer',
        'settings' => 'fashion_designer_scroll_top_alignment',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/layout2.png',
            'Right' => esc_url(get_template_directory_uri()).'/assets/images/layout3.png'
    ))));

    $wp_customize->add_setting('fashion_designer_reset_footer_settings',array(
      'sanitize_callback'	=> 'sanitize_text_field'
   	));
   	$wp_customize->add_control(new Fashion_Designer_Reset_Custom_Control($wp_customize, 'fashion_designer_reset_footer_settings',array(
      'type' => 'reset_control',
      'label' => __('Reset Footer Settings', 'fashion-designer'),
      'description' => 'fashion_designer_reset_all_settings',
      'section' => 'fashion_designer_footer'
   	)));

   	// footer social icon
	$wp_customize->add_setting( 'fashion_designer_footer_icon',array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
  	) );
	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_footer_icon',array(
		'label' => esc_html__( 'Show / Hide Footer Social Icon','fashion-designer' ),
		'section' => 'fashion_designer_footer'
  	)));

   	$wp_customize->add_setting('fashion_designer_align_footer_social_icon',array(
        'default' => 'center',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_align_footer_social_icon',array(
        'type' => 'select',
        'label' => __('Social Icon Alignment ','fashion-designer'),
        'section' => 'fashion_designer_footer',
        'choices' => array(
            'left' => __('Left','fashion-designer'),
            'right' => __('Right','fashion-designer'),
            'center' => __('Center','fashion-designer'),
        ),
	) );

	$wp_customize->add_setting( 'fashion_designer_copyright_sticky',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_copyright_sticky',array(
      'label' => esc_html__( 'Show / Hide Sticky Copyright','fashion-designer' ),
      'section' => 'fashion_designer_footer'
    )));

   $wp_customize->add_setting('fashion_designer_footer_social_icons_font_size',array(
       'default'=> 16,
       'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('fashion_designer_footer_social_icons_font_size',array(
    'label' => __('Social Icon Font Size','fashion-designer'),
    	'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'fashion_designer_footer',
	 ));

   	//Blog Post
	$wp_customize->add_panel( $FashionDesignerParentPanel );

	$BlogPostParentPanel = new Fashion_Designer_WP_Customize_Panel( $wp_customize, 'blog_post_parent_panel', array(
		'title' => __( 'Blog Post Settings', 'fashion-designer' ),
		'panel' => 'fashion_designer_panel_id',
	));

	$wp_customize->add_panel( $BlogPostParentPanel );

	// Add example section and controls to the middle (second) panel
	$wp_customize->add_section( 'fashion_designer_post_settings', array(
		'title' => __( 'Post Settings', 'fashion-designer' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Blog layout
    $wp_customize->add_setting('fashion_designer_blog_layout_option',array(
        'default' => 'Default',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
    ));
    $wp_customize->add_control(new Fashion_Designer_Image_Radio_Control($wp_customize, 'fashion_designer_blog_layout_option', array(
        'type' => 'select',
        'label' => __('Blog Layouts','fashion-designer'),
        'section' => 'fashion_designer_post_settings',
        'choices' => array(
            'Default' => esc_url(get_template_directory_uri()).'/assets/images/blog-layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/blog-layout2.png',
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/blog-layout3.png',
    ))));

	$wp_customize->add_setting('fashion_designer_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_theme_options',array(
        'type' => 'select',
        'label' => __('Post Sidebar Layout','fashion-designer'),
        'description' => __('Here you can change the sidebar layout for posts. ','fashion-designer'),
        'section' => 'fashion_designer_post_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','fashion-designer'),
            'Right Sidebar' => __('Right Sidebar','fashion-designer'),
            'One Column' => __('One Column','fashion-designer'),
            'Three Columns' => __('Three Columns','fashion-designer'),
            'Four Columns' => __('Four Columns','fashion-designer'),
            'Grid Layout' => __('Grid Layout','fashion-designer')
        ),
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('fashion_designer_toggle_postdate', array( 
		'selector' => '.post-main-box h2 a', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_toggle_postdate', 
	));

  	$wp_customize->add_setting('fashion_designer_toggle_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_toggle_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_post_settings',
		'setting'	=> 'fashion_designer_toggle_postdate_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'fashion_designer_toggle_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_toggle_postdate',array(
        'label' => esc_html__( 'Show / Hide Post Date','fashion-designer' ),
        'section' => 'fashion_designer_post_settings'
    )));

	$wp_customize->add_setting('fashion_designer_toggle_author_icon',array(
		'default'	=> 'far fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_toggle_author_icon',array(
		'label'	=> __('Add Author Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_post_settings',
		'setting'	=> 'fashion_designer_toggle_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'fashion_designer_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_toggle_author',array(
		'label' => esc_html__( 'Show / Hide Author','fashion-designer' ),
		'section' => 'fashion_designer_post_settings'
    )));

    $wp_customize->add_setting('fashion_designer_toggle_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_toggle_comments_icon',array(
		'label'	=> __('Add Comments Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_post_settings',
		'setting'	=> 'fashion_designer_toggle_comments_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'fashion_designer_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_toggle_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','fashion-designer' ),
		'section' => 'fashion_designer_post_settings'
    )));

    $wp_customize->add_setting('fashion_designer_toggle_time_icon',array(
		'default'	=> 'fas fa-clock', 
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_toggle_time_icon',array(
		'label'	=> __('Add Time Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_post_settings',
		'setting'	=> 'fashion_designer_toggle_time_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'fashion_designer_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_toggle_time',array(
		'label' => esc_html__( 'Show / Hide Time','fashion-designer' ),
		'section' => 'fashion_designer_post_settings'
    )));

    $wp_customize->add_setting( 'fashion_designer_featured_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
	));
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_featured_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','fashion-designer' ),
		'section' => 'fashion_designer_post_settings'
    )));

    $wp_customize->add_setting( 'fashion_designer_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_featured_image_border_radius', array(
		'label'       => esc_html__( 'Featured Image Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_post_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'fashion_designer_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Featured Image Box Shadow','fashion-designer' ),
		'section'     => 'fashion_designer_post_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Featured Image
	$wp_customize->add_setting('fashion_designer_blog_post_featured_image_dimension',array(
       'default' => 'default',
       'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
	));
  	$wp_customize->add_control('fashion_designer_blog_post_featured_image_dimension',array(
		'type' => 'select',
		'label'	=> __('Blog Post Featured Image Dimension','fashion-designer'),
		'section'	=> 'fashion_designer_post_settings',
		'choices' => array(
		'default' => __('Default','fashion-designer'),
		'custom' => __('Custom Image Size','fashion-designer'),
      ),
  	));

	$wp_customize->add_setting('fashion_designer_blog_post_featured_image_custom_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
		));
	$wp_customize->add_control('fashion_designer_blog_post_featured_image_custom_width',array(
		'label'	=> __('Featured Image Custom Width','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
    	'placeholder' => __( '10px', 'fashion-designer' ),),
		'section'=> 'fashion_designer_post_settings',
		'type'=> 'text',
		'active_callback' => 'fashion_designer_blog_post_featured_image_dimension'
		));

	$wp_customize->add_setting('fashion_designer_blog_post_featured_image_custom_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_blog_post_featured_image_custom_height',array(
		'label'	=> __('Featured Image Custom Height','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
    	'placeholder' => __( '10px', 'fashion-designer' ),),
		'section'=> 'fashion_designer_post_settings',
		'type'=> 'text',
		'active_callback' => 'fashion_designer_blog_post_featured_image_dimension'
	));

    $wp_customize->add_setting( 'fashion_designer_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','fashion-designer' ),
		'section'     => 'fashion_designer_post_settings',
		'type'        => 'range',
		'settings'    => 'fashion_designer_excerpt_number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('fashion_designer_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','fashion-designer'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','fashion-designer'),
		'section'=> 'fashion_designer_post_settings',
		'type'=> 'text'
	));

   	$wp_customize->add_setting('fashion_designer_blog_page_posts_settings',array(
        'default' => 'Into Blocks',
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_blog_page_posts_settings',array(
        'type' => 'select',
        'label' => __('Display Blog Posts','fashion-designer'),
        'section' => 'fashion_designer_post_settings',
        'choices' => array(
        	'Into Blocks' => __('Into Blocks','fashion-designer'),
            'Without Blocks' => __('Without Blocks','fashion-designer')
        ),
	) );

    $wp_customize->add_setting('fashion_designer_excerpt_settings',array(
        'default' => 'Excerpt',
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_excerpt_settings',array(
        'type' => 'select',
        'label' => __('Post Content','fashion-designer'),
        'section' => 'fashion_designer_post_settings',
        'choices' => array(
        	'Content' => __('Content','fashion-designer'),
            'Excerpt' => __('Excerpt','fashion-designer'),
            'No Content' => __('No Content','fashion-designer')
        ),
	) );

	$wp_customize->add_setting('fashion_designer_excerpt_suffix',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_excerpt_suffix',array(
		'label'	=> __('Add Excerpt Suffix','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '[...]', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_post_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fashion_designer_blog_pagination_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_blog_pagination_hide_show',array(
      'label' => esc_html__( 'Show / Hide Blog Pagination','fashion-designer' ),
      'section' => 'fashion_designer_post_settings'
    )));

	$wp_customize->add_setting( 'fashion_designer_blog_pagination_type', array(
        'default'			=> 'blog-page-numbers',
        'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
    ));
    $wp_customize->add_control( 'fashion_designer_blog_pagination_type', array(
        'section' => 'fashion_designer_post_settings',
        'type' => 'select',
        'label' => __( 'Blog Pagination', 'fashion-designer' ),
        'choices'		=> array(
            'blog-page-numbers'  => __( 'Numeric', 'fashion-designer' ),
            'next-prev' => __( 'Older Posts/Newer Posts', 'fashion-designer' ),
    )));

    // Button Settings
	$wp_customize->add_section( 'fashion_designer_button_settings', array(
		'title' => __( 'Button Settings', 'fashion-designer' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('fashion_designer_button_text', array( 
		'selector' => '.post-main-box .more-btn a', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_button_text', 
	));

	$wp_customize->add_setting('fashion_designer_button_text',array(
		'default'=> esc_html__( 'Read More', 'fashion-designer' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_button_text',array(
		'label'	=> __('Add Button Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Read More', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_button_settings',
		'type'=> 'text'
	));

	// font size button
	$wp_customize->add_setting('fashion_designer_button_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_button_font_size',array(
		'label'	=> __('Button Font Size','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
      	'placeholder' => __( '10px', 'fashion-designer' ),
    ),
    	'type'        => 'text',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'fashion_designer_button_settings',
	));

	$wp_customize->add_setting( 'fashion_designer_button_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_button_border_radius', array(
		'label'       => esc_html__( 'Button Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_button_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('fashion_designer_button_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_button_padding_top_bottom',array(
		'label'	=> __('Padding Top Bottom','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_button_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_button_padding_left_right',array(
		'label'	=> __('Padding Left Right','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_button_letter_spacing',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_button_letter_spacing',array(
		'label'	=> __('Button Letter Spacing','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
      	'placeholder' => __( '10px', 'fashion-designer' ),
    ),
    	'type'        => 'text',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'fashion_designer_button_settings',
	));

	// text trasform
	$wp_customize->add_setting('fashion_designer_button_text_transform',array(
		'default'=> 'Uppercase',
		'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_button_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Button Text Transform','fashion-designer'),
		'choices' => array(
            'Uppercase' => __('Uppercase','fashion-designer'),
            'Capitalize' => __('Capitalize','fashion-designer'),
            'Lowercase' => __('Lowercase','fashion-designer'),
        ),
		'section'=> 'fashion_designer_button_settings',
	));

	// Related Post Settings
	$wp_customize->add_section( 'fashion_designer_related_posts_settings', array(
		'title' => __( 'Related Posts Settings', 'fashion-designer' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('fashion_designer_related_post_title', array( 
		'selector' => '.related-post h3', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_related_post_title', 
	));

    $wp_customize->add_setting( 'fashion_designer_related_post',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_related_post',array(
		'label' => esc_html__( 'Show / Hide Related Post','fashion-designer' ),
		'section' => 'fashion_designer_related_posts_settings'
    )));

    $wp_customize->add_setting('fashion_designer_related_post_title',array(
		'default'=> 'Related Post',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_related_post_title',array(
		'label'	=> __('Add Related Post Title','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Related Post', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_related_posts_settings',
		'type'=> 'text'
	));

   	$wp_customize->add_setting('fashion_designer_related_posts_count',array(
		'default'=> '3',
		'sanitize_callback'	=> 'fashion_designer_sanitize_float'
	));
	$wp_customize->add_control('fashion_designer_related_posts_count',array(
		'label'	=> __('Add Related Post Count','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '3', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_related_posts_settings',
		'type'=> 'number'
	));

	$wp_customize->add_setting( 'fashion_designer_related_posts_excerpt_number', array(
		'default'              => 20,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_related_posts_excerpt_number', array(
		'label'       => esc_html__( 'Related Posts Excerpt length','fashion-designer' ),
		'section'     => 'fashion_designer_related_posts_settings',
		'type'        => 'range',
		'settings'    => 'fashion_designer_related_posts_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'fashion_designer_related_toggle_postdate',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'fashion_designer_switch_sanitization'
  	));
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_related_toggle_postdate',array(
	    'label' => esc_html__( 'Show / Hide Post Date','fashion-designer' ),
	    'section' => 'fashion_designer_related_posts_settings'
  	)));

  	$wp_customize->add_setting('fashion_designer_related_postdate_icon',array(
	    'default' => 'fas fa-calendar-alt',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
  	$wp_customize,'fashion_designer_related_postdate_icon',array(
	    'label' => __('Add Post Date Icon','fashion-designer'),
	    'transport' => 'refresh',
	    'section' => 'fashion_designer_related_posts_settings',
	    'setting' => 'fashion_designer_related_postdate_icon',
	    'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'fashion_designer_related_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
  	));
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_related_toggle_author',array(
		'label' => esc_html__( 'Show / Hide Author','fashion-designer' ),
		'section' => 'fashion_designer_related_posts_settings'
  	)));

  	$wp_customize->add_setting('fashion_designer_related_author_icon',array(
	    'default' => 'fas fa-user',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
  	$wp_customize,'fashion_designer_related_author_icon',array(
	    'label' => __('Add Author Icon','fashion-designer'),
	    'transport' => 'refresh',
	    'section' => 'fashion_designer_related_posts_settings',
	    'setting' => 'fashion_designer_related_author_icon',
	    'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'fashion_designer_related_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
  	) );
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_related_toggle_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','fashion-designer' ),
		'section' => 'fashion_designer_related_posts_settings'
  	)));

  	$wp_customize->add_setting('fashion_designer_related_comments_icon',array(
	    'default' => 'fa fa-comments',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
  	$wp_customize,'fashion_designer_related_comments_icon',array(
	    'label' => __('Add Comments Icon','fashion-designer'),
	    'transport' => 'refresh',
	    'section' => 'fashion_designer_related_posts_settings',
	    'setting' => 'fashion_designer_related_comments_icon',
	    'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'fashion_designer_related_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
  	) );
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_related_toggle_time',array(
		'label' => esc_html__( 'Show / Hide Time','fashion-designer' ),
		'section' => 'fashion_designer_related_posts_settings'
  	)));

  	$wp_customize->add_setting('fashion_designer_related_time_icon',array(
	    'default' => 'fas fa-clock',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
  	$wp_customize,'fashion_designer_related_time_icon',array(
	    'label' => __('Add Time Icon','fashion-designer'),
	    'transport' => 'refresh',
	    'section' => 'fashion_designer_related_posts_settings',
	    'setting' => 'fashion_designer_related_time_icon',
	    'type'    => 'icon'
  	)));

  	$wp_customize->add_setting('fashion_designer_related_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_related_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','fashion-designer'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','fashion-designer'),
		'section'=> 'fashion_designer_related_posts_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fashion_designer_related_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
	));
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_related_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','fashion-designer' ),
		'section' => 'fashion_designer_related_posts_settings'
  	)));

  	$wp_customize->add_setting( 'fashion_designer_related_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_related_image_box_shadow', array(
		'label'       => esc_html__( 'Related post Image Box Shadow','fashion-designer' ),
		'section'     => 'fashion_designer_related_posts_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

  	$wp_customize->add_setting('fashion_designer_related_button_text',array(
		'default'=> esc_html__('Read More','fashion-designer'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_related_button_text',array(
		'label'	=> esc_html__('Add Button Text','fashion-designer'),
		'input_attrs' => array(
      'placeholder' => esc_html__( 'Read More', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_related_posts_settings',
		'type'=> 'text'
	));


	// Single Posts Settings
	$wp_customize->add_section( 'fashion_designer_single_blog_settings', array(
		'title' => __( 'Single Post Settings', 'fashion-designer' ),
		'panel' => 'blog_post_parent_panel',
	));

  	$wp_customize->add_setting('fashion_designer_single_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_single_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_single_blog_settings',
		'setting'	=> 'fashion_designer_single_postdate_icon',
		'type'		=> 'icon'
	)));

 	$wp_customize->add_setting( 'fashion_designer_single_postdate',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'fashion_designer_switch_sanitization'
	) );
	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_postdate',array(
	    'label' => esc_html__( 'Show / Hide Date','fashion-designer' ),
	   'section' => 'fashion_designer_single_blog_settings'
	)));

	$wp_customize->add_setting('fashion_designer_single_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_single_author_icon',array(
		'label'	=> __('Add Author Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_single_blog_settings',
		'setting'	=> 'fashion_designer_single_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'fashion_designer_single_author',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'fashion_designer_switch_sanitization'
	) );
	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_author',array(
	    'label' => esc_html__( 'Show / Hide Author','fashion-designer' ),
	    'section' => 'fashion_designer_single_blog_settings'
	)));

   	$wp_customize->add_setting('fashion_designer_single_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_single_comments_icon',array(
		'label'	=> __('Add Comments Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_single_blog_settings',
		'setting'	=> 'fashion_designer_single_comments_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'fashion_designer_single_comments',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'fashion_designer_switch_sanitization'
	) );
	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_comments',array(
	    'label' => esc_html__( 'Show / Hide Comments','fashion-designer' ),
	    'section' => 'fashion_designer_single_blog_settings'
	)));

  	$wp_customize->add_setting('fashion_designer_single_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_single_time_icon',array(
		'label'	=> __('Add Time Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_single_blog_settings',
		'setting'	=> 'fashion_designer_single_time_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'fashion_designer_single_time',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'fashion_designer_switch_sanitization'
	) );
	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_time',array(
	    'label' => esc_html__( 'Show / Hide Time','fashion-designer' ),
	    'section' => 'fashion_designer_single_blog_settings'
	)));

	$wp_customize->add_setting( 'fashion_designer_toggle_tags',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
	));
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_toggle_tags', array(
		'label' => esc_html__( 'Show / Hide Tags','fashion-designer' ),
		'section' => 'fashion_designer_single_blog_settings'
    )));

   	$wp_customize->add_setting( 'fashion_designer_single_post_breadcrumb',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_post_breadcrumb',array(
		'label' => esc_html__( 'Show / Hide Breadcrumb','fashion-designer' ),
		'section' => 'fashion_designer_single_blog_settings'
    )));

     // Single Posts Category
  	$wp_customize->add_setting( 'fashion_designer_single_post_category',array(
		'default' => true,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_post_category',array(
		'label' => esc_html__( 'Show / Hide Category','fashion-designer' ),
		'section' => 'fashion_designer_single_blog_settings'
    )));

	$wp_customize->add_setting( 'fashion_designer_single_blog_post_navigation_show_hide',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
	));
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_blog_post_navigation_show_hide', array(
		'label' => esc_html__( 'Show / Hide Post Navigation','fashion-designer' ),
		'section' => 'fashion_designer_single_blog_settings'
    )));

    $wp_customize->add_setting( 'fashion_designer_singlepost_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_singlepost_image_box_shadow', array(
		'label'       => esc_html__( 'Single post Image Box Shadow','fashion-designer' ),
		'section'     => 'fashion_designer_single_blog_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('fashion_designer_single_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_single_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','fashion-designer'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','fashion-designer'),
		'section'=> 'fashion_designer_single_blog_settings',
		'type'=> 'text'
	));

	//navigation text
	$wp_customize->add_setting('fashion_designer_single_blog_prev_navigation_text',array(
		'default'=> 'PREVIOUS',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_single_blog_prev_navigation_text',array(
		'label'	=> __('Post Navigation Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'PREVIOUS', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_single_blog_next_navigation_text',array(
		'default'=> 'NEXT',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_single_blog_next_navigation_text',array(
		'label'	=> __('Post Navigation Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'NEXT', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_single_blog_comment_title',array(
		'default'=> 'Leave a Reply',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('fashion_designer_single_blog_comment_title',array(
		'label'	=> __('Add Comment Title','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Leave a Reply', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_single_blog_comment_button_text',array(
		'default'=> 'Post Comment',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('fashion_designer_single_blog_comment_button_text',array(
		'label'	=> __('Add Comment Button Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Post Comment', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_single_blog_comment_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_single_blog_comment_width',array(
		'label'	=> __('Comment Form Width','fashion-designer'),
		'description'	=> __('Enter a value in %. Example:50%','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '100%', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_single_blog_settings',
		'type'=> 'text'
	));

	// Grid layout setting
	$wp_customize->add_section( 'fashion_designer_grid_layout_settings', array(
		'title' => __( 'Grid Layout Settings', 'fashion-designer' ),
		'panel' => 'blog_post_parent_panel',
	));

  	$wp_customize->add_setting('fashion_designer_grid_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_grid_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_grid_layout_settings',
		'setting'	=> 'fashion_designer_grid_postdate_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'fashion_designer_grid_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_grid_postdate',array(
        'label' => esc_html__( 'Show / Hide Post Date','fashion-designer' ),
        'section' => 'fashion_designer_grid_layout_settings'
    )));

	$wp_customize->add_setting('fashion_designer_grid_author_icon',array(
		'default'	=> 'far fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_grid_author_icon',array(
		'label'	=> __('Add Author Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_grid_layout_settings',
		'setting'	=> 'fashion_designer_grid_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'fashion_designer_grid_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_grid_author',array(
		'label' => esc_html__( 'Show / Hide Author','fashion-designer' ),
		'section' => 'fashion_designer_grid_layout_settings'
    )));

   	$wp_customize->add_setting('fashion_designer_grid_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_grid_comments_icon',array(
		'label'	=> __('Add Comments Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_grid_layout_settings',
		'setting'	=> 'fashion_designer_grid_comments_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'fashion_designer_grid_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_grid_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','fashion-designer' ),
		'section' => 'fashion_designer_grid_layout_settings'
    )));

    $wp_customize->add_setting( 'fashion_designer_grid_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
	));
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_grid_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','fashion-designer' ),
		'section' => 'fashion_designer_grid_layout_settings'
  	)));


 	$wp_customize->add_setting('fashion_designer_grid_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_grid_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','fashion-designer'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','fashion-designer'),
		'section'=> 'fashion_designer_grid_layout_settings',
		'type'=> 'text'
	)); 

	$wp_customize->add_setting('fashion_designer_display_grid_posts_settings',array(
    'default' => 'Into Blocks',
    'transport' => 'refresh',
    'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_display_grid_posts_settings',array(
    'type' => 'select',
    'label' => __('Display Grid Posts','fashion-designer'),
    'section' => 'fashion_designer_grid_layout_settings',
    'choices' => array(
    	'Into Blocks' => __('Into Blocks','fashion-designer'),
      'Without Blocks' => __('Without Blocks','fashion-designer')
      ),
	) );

	$wp_customize->add_setting('fashion_designer_grid_button_text',array(
		'default'=> esc_html__('Read More','fashion-designer'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_grid_button_text',array(
		'label'	=> esc_html__('Add Button Text','fashion-designer'),
		'input_attrs' => array(
        'placeholder' => esc_html__( 'Read More', 'fashion-designer' ),
      ),
		'section'=> 'fashion_designer_grid_layout_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_grid_excerpt_suffix',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_grid_excerpt_suffix',array(
		'label'	=> __('Add Excerpt Suffix','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '[...]', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_grid_layout_settings',
		'type'=> 'text'
	));

	// other settings
	$OtherParentPanel = new Fashion_Designer_WP_Customize_Panel( $wp_customize, 'fashion_designer_other_panel_id', array(
		'title' => __( 'Others Settings', 'fashion-designer' ),
		'panel' => 'fashion_designer_panel_id',
	));

	$wp_customize->add_panel( $OtherParentPanel );

	// Layout
	$wp_customize->add_section( 'fashion_designer_left_right', array(
    	'title'      => esc_html__( 'General Settings', 'fashion-designer' ),
		'panel' => 'fashion_designer_other_panel_id'
	) );

	$wp_customize->add_setting('fashion_designer_width_option',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control(new Fashion_Designer_Image_Radio_Control($wp_customize, 'fashion_designer_width_option', array(
        'type' => 'select',
        'label' => __('Width Layouts','fashion-designer'),
        'description' => __('Here you can change the width layout of Website.','fashion-designer'),
        'section' => 'fashion_designer_left_right',
        'choices' => array(
            'Full Width' => esc_url(get_template_directory_uri()).'/assets/images/full-width.png',
            'Wide Width' => esc_url(get_template_directory_uri()).'/assets/images/wide-width.png',
            'Boxed' => esc_url(get_template_directory_uri()).'/assets/images/boxed-width.png',
    ))));

	$wp_customize->add_setting('fashion_designer_page_layout',array(
        'default' => 'One Column',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_page_layout',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','fashion-designer'),
        'description' => __('Here you can change the sidebar layout for pages. ','fashion-designer'),
        'section' => 'fashion_designer_left_right',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','fashion-designer'),
            'Right Sidebar' => __('Right Sidebar','fashion-designer'),
            'One Column' => __('One Column','fashion-designer')
        ),
	) );

	$wp_customize->add_setting( 'fashion_designer_single_page_breadcrumb',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_single_page_breadcrumb',array(
		'label' => esc_html__( 'Show / Hide Page Breadcrumb','fashion-designer' ),
		'section' => 'fashion_designer_left_right'
    )));

    $wp_customize->add_setting('fashion_designer_breadcrumbs_alignment',array(
        'default' => 'Left',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_breadcrumbs_alignment',array(
        'type' => 'select',
        'label' => __('Breadcrumbs Alignment','fashion-designer'),
        'section' => 'fashion_designer_left_right',
        'choices' => array(
            'Left' => __('Left','fashion-designer'),
            'Right' => __('Right','fashion-designer'),
            'Center' => __('Center','fashion-designer'),
        ),
	) );

	//Wow Animation
	$wp_customize->add_setting( 'fashion_designer_animation',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_animation',array(
        'label' => esc_html__( 'Show / Hide Animation ','fashion-designer' ),
        'description' => __('Here you can disable overall site animation effect','fashion-designer'),
        'section' => 'fashion_designer_left_right'
    )));

	//Pre-Loader
	$wp_customize->add_setting( 'fashion_designer_loader_enable',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_loader_enable',array(
        'label' => esc_html__( 'Show / Hide Pre-Loader','fashion-designer' ),
        'section' => 'fashion_designer_left_right'
    )));

	$wp_customize->add_setting('fashion_designer_preloader_bg_color', array(
		'default'           => '#d1b266',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_preloader_bg_color', array(
		'label'    => __('Pre-Loader Background Color', 'fashion-designer'),
		'section'  => 'fashion_designer_left_right',
	)));

	$wp_customize->add_setting('fashion_designer_preloader_border_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_preloader_border_color', array(
		'label'    => __('Pre-Loader Border Color', 'fashion-designer'),
		'section'  => 'fashion_designer_left_right',
	)));

	$wp_customize->add_setting('fashion_designer_preloader_bg_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'fashion_designer_preloader_bg_img',array(
        'label' => __('Preloader Background Image','fashion-designer'),
        'section' => 'fashion_designer_left_right'
	)));

    //404 Page Setting
	$wp_customize->add_section('fashion_designer_404_page',array(
		'title'	=> __('404 Page Settings','fashion-designer'),
		'panel' => 'fashion_designer_other_panel_id',
	));	

	$wp_customize->add_setting('fashion_designer_404_page_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('fashion_designer_404_page_title',array(
		'label'	=> __('Add Title','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '404 Not Found', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_404_page_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('fashion_designer_404_page_content',array(
		'label'	=> __('Add Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Looks like you have taken a wrong turn, Dont worry, it happens to the best of us.', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_404_page_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_404_page_button_text',array(
		'label'	=> __('Add Button Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Go Back', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_404_page',
		'type'=> 'text'
	));

	//No Result Page Setting
	$wp_customize->add_section('fashion_designer_no_results_page',array(
		'title'	=> __('No Results Page Settings','fashion-designer'),
		'panel' => 'fashion_designer_other_panel_id',
	));	

	$wp_customize->add_setting('fashion_designer_no_results_page_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('fashion_designer_no_results_page_title',array(
		'label'	=> __('Add Title','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Nothing Found', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_no_results_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_no_results_page_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('fashion_designer_no_results_page_content',array(
		'label'	=> __('Add Text','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_no_results_page',
		'type'=> 'text'
	));

	//Social Icon Setting
	$wp_customize->add_section('fashion_designer_social_icon_settings',array(
		'title'	=> __('Social Icons Settings','fashion-designer'),
		'panel' => 'fashion_designer_other_panel_id',
	));	

	$wp_customize->add_setting('fashion_designer_social_icon_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_social_icon_font_size',array(
		'label'	=> __('Icon Font Size','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_social_icon_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_social_icon_padding',array(
		'label'	=> __('Icon Padding','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_social_icon_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_social_icon_width',array(
		'label'	=> __('Icon Width','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_social_icon_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_social_icon_height',array(
		'label'	=> __('Icon Height','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fashion_designer_social_icon_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_social_icon_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_social_icon_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Responsive Media Settings
	$wp_customize->add_section('fashion_designer_responsive_media',array(
		'title'	=> __('Responsive Media','fashion-designer'),
		'panel' => 'fashion_designer_other_panel_id',
	));

    $wp_customize->add_setting( 'fashion_designer_stickyheader_hide_show',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_stickyheader_hide_show',array(
      'label' => esc_html__( 'Show / Hide Sticky Header','fashion-designer' ),
      'section' => 'fashion_designer_responsive_media'
    )));

    $wp_customize->add_setting( 'fashion_designer_resp_topbar_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
  	));  
  	$wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_resp_topbar_hide_show',array(
      'label' => esc_html__( 'Show / Hide Topbar','fashion-designer' ),
      'section' => 'fashion_designer_responsive_media'
  	)));

    $wp_customize->add_setting( 'fashion_designer_resp_slider_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_resp_slider_hide_show',array(
      'label' => esc_html__( 'Show / Hide Slider','fashion-designer' ),
      'section' => 'fashion_designer_responsive_media'
    )));

    $wp_customize->add_setting( 'fashion_designer_sidebar_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_sidebar_hide_show',array(
      'label' => esc_html__( 'Show / Hide Sidebar','fashion-designer' ),
      'section' => 'fashion_designer_responsive_media'
    )));

   	$wp_customize->add_setting( 'fashion_designer_responsive_preloader_hide',array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_responsive_preloader_hide',array(
        'label' => esc_html__( 'Show / Hide Preloader','fashion-designer' ),
        'section' => 'fashion_designer_responsive_media'
    )));

    $wp_customize->add_setting( 'fashion_designer_resp_scroll_top_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ));  
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_resp_scroll_top_hide_show',array(
      'label' => esc_html__( 'Show / Hide Scroll To Top','fashion-designer' ),
      'section' => 'fashion_designer_responsive_media'
    )));

    $wp_customize->add_setting('fashion_designer_res_open_menu_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_res_open_menu_icon',array(
		'label'	=> __('Add Open Menu Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_responsive_media',
		'setting'	=> 'fashion_designer_res_open_menu_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('fashion_designer_res_menu_close_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Fashion_Designer_Fontawesome_Icon_Chooser(
        $wp_customize,'fashion_designer_res_menu_close_icon',array(
		'label'	=> __('Add Close Menu Icon','fashion-designer'),
		'transport' => 'refresh',
		'section'	=> 'fashion_designer_responsive_media',
		'setting'	=> 'fashion_designer_res_menu_close_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('fashion_designer_resp_menu_toggle_btn_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fashion_designer_resp_menu_toggle_btn_bg_color', array(
		'label'    => __('Toggle Button Bg Color', 'fashion-designer'),
		'section'  => 'fashion_designer_responsive_media',
	)));

    //Woocommerce settings
	$wp_customize->add_section('fashion_designer_woocommerce_section', array(
		'title'    => __('WooCommerce Layout', 'fashion-designer'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

    //Shop Page Featured Image
	$wp_customize->add_setting( 'fashion_designer_shop_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_shop_featured_image_border_radius', array(
		'label'       => esc_html__( 'Shop Page Featured Image Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'fashion_designer_shop_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_shop_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Shop Page Featured Image Box Shadow','fashion-designer' ),
		'section'     => 'fashion_designer_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'fashion_designer_woocommerce_shop_page_sidebar', array( 'selector' => '.post-type-archive-product #sidebar', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_woocommerce_shop_page_sidebar', ) );

    //Woocommerce Shop Page Sidebar
	$wp_customize->add_setting( 'fashion_designer_woocommerce_shop_page_sidebar',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_woocommerce_shop_page_sidebar',array(
		'label' => esc_html__( 'Shop Page Sidebar','fashion-designer' ),
		'section' => 'fashion_designer_woocommerce_section'
    )));

    $wp_customize->add_setting('fashion_designer_shop_page_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_shop_page_layout',array(
        'type' => 'select',
        'label' => __('Shop Page Sidebar Layout','fashion-designer'),
        'section' => 'fashion_designer_woocommerce_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','fashion-designer'),
            'Right Sidebar' => __('Right Sidebar','fashion-designer'),
        ),
	) );

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'fashion_designer_woocommerce_single_product_page_sidebar', array( 'selector' => '.single-product #sidebar', 
		'render_callback' => 'fashion_designer_customize_partial_fashion_designer_woocommerce_single_product_page_sidebar', ) );

    //Woocommerce Single Product page Sidebar
	$wp_customize->add_setting( 'fashion_designer_woocommerce_single_product_page_sidebar',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_woocommerce_single_product_page_sidebar',array(
		'label' => esc_html__( 'Single Product Sidebar','fashion-designer' ),
		'section' => 'fashion_designer_woocommerce_section'
    )));

   	$wp_customize->add_setting('fashion_designer_single_product_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_single_product_layout',array(
        'type' => 'select',
        'label' => __('Single Product Sidebar Layout','fashion-designer'),
        'section' => 'fashion_designer_woocommerce_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','fashion-designer'),
            'Right Sidebar' => __('Right Sidebar','fashion-designer'),
        ),
	) );

    //Products per page
    $wp_customize->add_setting('fashion_designer_products_per_page',array(
		'default'=> '9',
		'sanitize_callback'	=> 'fashion_designer_sanitize_float'
	));
	$wp_customize->add_control('fashion_designer_products_per_page',array(
		'label'	=> __('Products Per Page','fashion-designer'),
		'description' => __('Display on shop page','fashion-designer'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'number',
	));

    //Products per row
    $wp_customize->add_setting('fashion_designer_products_per_row',array(
		'default'=> '3',
		'sanitize_callback'	=> 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_products_per_row',array(
		'label'	=> __('Products Per Row','fashion-designer'),
		'description' => __('Display on shop page','fashion-designer'),
		'choices' => array(
            '2' => '2',
			'3' => '3',
			'4' => '4',
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'select',
	));

	//Products padding
	$wp_customize->add_setting('fashion_designer_products_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_products_padding_top_bottom',array(
		'label'	=> __('Products Padding Top Bottom','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_products_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_products_padding_left_right',array(
		'label'	=> __('Products Padding Left Right','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'text'
	));

	//Products box shadow
	$wp_customize->add_setting( 'fashion_designer_products_box_shadow', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_products_box_shadow', array(
		'label'       => esc_html__( 'Products Box Shadow','fashion-designer' ),
		'section'     => 'fashion_designer_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Products border radius
    $wp_customize->add_setting( 'fashion_designer_products_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_products_border_radius', array(
		'label'       => esc_html__( 'Products Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('fashion_designer_products_btn_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_products_btn_padding_top_bottom',array(
		'label'	=> __('Products Button Padding Top Bottom','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_products_btn_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_products_btn_padding_left_right',array(
		'label'	=> __('Products Button Padding Left Right','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fashion_designer_products_button_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_products_button_border_radius', array(
		'label'       => esc_html__( 'Products Button Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Products Sale Badge
	$wp_customize->add_setting('fashion_designer_woocommerce_sale_position',array(
        'default' => 'right',
        'sanitize_callback' => 'fashion_designer_sanitize_choices'
	));
	$wp_customize->add_control('fashion_designer_woocommerce_sale_position',array(
        'type' => 'select',
        'label' => __('Sale Badge Position','fashion-designer'),
        'section' => 'fashion_designer_woocommerce_section',
        'choices' => array(
            'left' => __('Left','fashion-designer'),
            'right' => __('Right','fashion-designer'),
        ),
	) );

	$wp_customize->add_setting('fashion_designer_woocommerce_sale_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_woocommerce_sale_font_size',array(
		'label'	=> __('Sale Font Size','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_woocommerce_sale_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_woocommerce_sale_padding_top_bottom',array(
		'label'	=> __('Sale Padding Top Bottom','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('fashion_designer_woocommerce_sale_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('fashion_designer_woocommerce_sale_padding_left_right',array(
		'label'	=> __('Sale Padding Left Right','fashion-designer'),
		'description'	=> __('Enter a value in pixels. Example:20px','fashion-designer'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'fashion-designer' ),
        ),
		'section'=> 'fashion_designer_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'fashion_designer_woocommerce_sale_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'fashion_designer_sanitize_number_range'
	) );
	$wp_customize->add_control( 'fashion_designer_woocommerce_sale_border_radius', array(
		'label'       => esc_html__( 'Sale Border Radius','fashion-designer' ),
		'section'     => 'fashion_designer_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

  	// Related Product
    $wp_customize->add_setting( 'fashion_designer_related_product_show_hide',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'fashion_designer_switch_sanitization'
    ) );
    $wp_customize->add_control( new Fashion_Designer_Toggle_Switch_Custom_Control( $wp_customize, 'fashion_designer_related_product_show_hide',array(
        'label' => esc_html__( 'Related product','fashion-designer' ),
        'section' => 'fashion_designer_woocommerce_section'
    )));

    // Has to be at the top
	$wp_customize->register_panel_type( 'Fashion_Designer_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'Fashion_Designer_WP_Customize_Section' );
}

add_action( 'customize_register', 'fashion_designer_customize_register' );

load_template( trailingslashit( get_template_directory() ) . '/inc/logo/logo-resizer.php' );

if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class Fashion_Designer_WP_Customize_Panel extends WP_Customize_Panel {
	    public $panel;
	    public $type = 'fashion_designer_panel';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class Fashion_Designer_WP_Customize_Section extends WP_Customize_Section {
	    public $section;
	    public $type = 'fashion_designer_section';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}

// Enqueue our scripts and styles
function fashion_designer_customize_controls_scripts() {
  wp_enqueue_script( 'customizer-controls', get_theme_file_uri( '/assets/js/customizer-controls.js' ), array(), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'fashion_designer_customize_controls_scripts' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Fashion_Designer_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	*/
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Fashion_Designer_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section( new Fashion_Designer_Customize_Section_Pro( $manager,'fashion_designer_upgrade_pro_link', array(
			'priority'   => 1,
			'title'    => esc_html__( 'Fashion Designer Pro', 'fashion-designer' ),
			'pro_text' => esc_html__( 'UPGRADE PRO', 'fashion-designer' ),
			'pro_url'  => esc_url('https://www.buywptemplates.com/products/fashion-designer-wordpress-theme'),
		)));

		$manager->add_section(new Fashion_Designer_Customize_Section_Pro($manager,'fashion_designer_get_started_link',array(
			'priority'   => 1,
			'title'    => esc_html__( 'DOCUMENTATION', 'fashion-designer' ),
			'pro_text' => esc_html__( 'DOCS', 'fashion-designer' ),
			'pro_url'  => esc_url('https://demos.buywptemplates.com/demo/docs/free-fashion-designer/'),
		)));
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'fashion-designer-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'fashion-designer-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );

		wp_localize_script(
		'fashion-designer-customize-controls',
		'fashion_designer_customizer_params',
		array(
			'ajaxurl' =>	admin_url( 'admin-ajax.php' )
		));
	}
}

// Doing this customizer thang!
Fashion_Designer_Customize::get_instance();