<?php
/**
 * Fashion Designer: Block Patterns
 *
 * @package Fashion Designer
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'fashion-designer',
		array( 'label' => __( 'Fashion Designer', 'fashion-designer' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'fashion-designer/banner-section',
		array(
			'title'      => __( 'Banner Section', 'fashion-designer' ),
			'categories' => array( 'fashion-designer' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png\",\"id\":9754,\"dimRatio\":70,\"customGradient\":\"linear-gradient(100deg,rgb(0,0,0) 0%,rgb(0,0,0) 100%)\",\"align\":\"full\",\"className\":\"is-light main-banner-section\"} -->\n<div class=\"wp-block-cover alignfull is-light main-banner-section\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-70 has-background-dim wp-block-cover__gradient-background has-background-gradient\" style=\"background:linear-gradient(100deg,rgb(0,0,0) 0%,rgb(0,0,0) 100%)\"></span><img class=\"wp-block-cover__image-background wp-image-9754\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\",\"className\":\"m-0\"} -->\n<div class=\"wp-block-columns alignwide m-0\"><!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}}},\"textColor\":\"white\",\"className\":\"mb-1\",\"fontSize\":\"normal\"} -->\n<h3 class=\"wp-block-heading has-text-align-center mb-1 has-white-color has-text-color has-link-color has-normal-font-size\">Te obtinuit ut adepto satis somno allisque</h3>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":40},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|white\"}}}},\"textColor\":\"white\"} -->\n<h1 class=\"wp-block-heading has-text-align-center has-white-color has-text-color has-link-color\" style=\"font-size:40px\">TE OBTINUIT UT ADEPTO</h1>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\"} -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-white-color has-text-color wp-element-button\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'fashion-designer/category-section',
		array(
			'title'      => __( 'Category Section', 'fashion-designer' ),
			'categories' => array( 'fashion-designer' ),
			'content'    => "<!-- wp:cover {\"overlayColor\":\"white\",\"align\":\"wide\",\"className\":\"is-light category-section mx-0 p-4 mb-5\"} -->\n<div class=\"wp-block-cover alignwide is-light category-section mx-0 p-4 mb-5\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\",\"className\":\"mx-0\"} -->\n<div class=\"wp-block-columns alignwide mx-0\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-outer-box\"} -->\n<div class=\"wp-block-group category-outer-box\"><!-- wp:image {\"id\":9763,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/cat-image1.png\" alt=\"\" class=\"wp-image-9763\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"inner-cat-box\"} -->\n<div class=\"wp-block-group inner-cat-box\"><!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"80%\",\"className\":\"cat-title\"} -->\n<div class=\"wp-block-column cat-title\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":18}},\"textColor\":\"white\",\"className\":\"mt-3 mb-0\"} -->\n<h2 class=\"wp-block-heading has-text-align-left mt-3 mb-0 has-white-color has-text-color\" style=\"font-size:18px\">CATEGORY TITLE 1</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"cat-btn\"} -->\n<div class=\"wp-block-column cat-btn\" style=\"flex-basis:20%\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button /--></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-outer-box\"} -->\n<div class=\"wp-block-group category-outer-box\"><!-- wp:image {\"id\":9764,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/cat-image2.png\" alt=\"\" class=\"wp-image-9764\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"inner-cat-box\"} -->\n<div class=\"wp-block-group inner-cat-box\"><!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"80%\",\"className\":\"cat-title\"} -->\n<div class=\"wp-block-column cat-title\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":18}},\"textColor\":\"white\",\"className\":\"mt-3 mb-0\"} -->\n<h2 class=\"wp-block-heading has-text-align-left mt-3 mb-0 has-white-color has-text-color\" style=\"font-size:18px\">CATEGORY TITLE 1</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"cat-btn\"} -->\n<div class=\"wp-block-column cat-btn\" style=\"flex-basis:20%\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button /--></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-outer-box\"} -->\n<div class=\"wp-block-group category-outer-box\"><!-- wp:image {\"id\":9765,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/cat-image3.png\" alt=\"\" class=\"wp-image-9765\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"inner-cat-box\"} -->\n<div class=\"wp-block-group inner-cat-box\"><!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"80%\",\"className\":\"cat-title\"} -->\n<div class=\"wp-block-column cat-title\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":18}},\"textColor\":\"white\",\"className\":\"mt-3 mb-0\"} -->\n<h2 class=\"wp-block-heading has-text-align-left mt-3 mb-0 has-white-color has-text-color\" style=\"font-size:18px\">CATEGORY TITLE 1</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"cat-btn\"} -->\n<div class=\"wp-block-column cat-btn\" style=\"flex-basis:20%\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button /--></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"align\":\"wide\",\"className\":\"mx-0\"} -->\n<div class=\"wp-block-columns alignwide mx-0\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-outer-box\"} -->\n<div class=\"wp-block-group category-outer-box\"><!-- wp:image {\"id\":9766,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/cat-image4.png\" alt=\"\" class=\"wp-image-9766\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"inner-cat-box\"} -->\n<div class=\"wp-block-group inner-cat-box\"><!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"80%\",\"className\":\"cat-title\"} -->\n<div class=\"wp-block-column cat-title\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":18}},\"textColor\":\"white\",\"className\":\"mt-3 mb-0\"} -->\n<h2 class=\"wp-block-heading has-text-align-left mt-3 mb-0 has-white-color has-text-color\" style=\"font-size:18px\">CATEGORY TITLE 1</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"cat-btn\"} -->\n<div class=\"wp-block-column cat-btn\" style=\"flex-basis:20%\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button /--></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-outer-box\"} -->\n<div class=\"wp-block-group category-outer-box\"><!-- wp:image {\"id\":9767,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/cat-image5.png\" alt=\"\" class=\"wp-image-9767\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"inner-cat-box\"} -->\n<div class=\"wp-block-group inner-cat-box\"><!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"80%\",\"className\":\"cat-title\"} -->\n<div class=\"wp-block-column cat-title\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":18}},\"textColor\":\"white\",\"className\":\"mt-3 mb-0\"} -->\n<h2 class=\"wp-block-heading has-text-align-left mt-3 mb-0 has-white-color has-text-color\" style=\"font-size:18px\">CATEGORY TITLE 1</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"cat-btn\"} -->\n<div class=\"wp-block-column cat-btn\" style=\"flex-basis:20%\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button /--></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"category-outer-box\"} -->\n<div class=\"wp-block-group category-outer-box\"><!-- wp:image {\"id\":9768,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/cat-image6.png\" alt=\"\" class=\"wp-image-9768\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"className\":\"inner-cat-box\"} -->\n<div class=\"wp-block-group inner-cat-box\"><!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"80%\",\"className\":\"cat-title\"} -->\n<div class=\"wp-block-column cat-title\" style=\"flex-basis:80%\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":18}},\"textColor\":\"white\",\"className\":\"mt-3 mb-0\"} -->\n<h2 class=\"wp-block-heading has-text-align-left mt-3 mb-0 has-white-color has-text-color\" style=\"font-size:18px\">CATEGORY TITLE 1</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"className\":\"cat-btn\"} -->\n<div class=\"wp-block-column cat-btn\" style=\"flex-basis:20%\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button /--></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->",
		)
	);
}