<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div class="header-footer-bg">

<div onclick="dw_mekatron_topFunction()" id="TopBtn"></div>

<nav role="navigation" id="skip" aria-label="<?php echo esc_attr_x( 'Skip links', 'ARIA label', 'dw-mekatron' ); ?>">

	<?php if ( is_active_sidebar( 'left-sidebar' ) ) : ?>

	<a class="tab-shortcut" id="shortcut-left-sidebar" href="#left"><?php is_active_sidebar( 'right-sidebar' ) ? esc_html_e( 'Skip to first sidebar', 'dw-mekatron' ) : esc_html_e( 'Skip to sidebar', 'dw-mekatron' ); ?></a>

	<?php endif; ?>

	<a class="tab-shortcut" id="shortcut-content" href="#content"><?php esc_html_e( 'Skip to content', 'dw-mekatron' ); ?></a>

	<?php if ( is_active_sidebar( 'right-sidebar' ) ) : ?>

	<a class="tab-shortcut" id="shortcut-right-sidebar" href="#right"><?php is_active_sidebar( 'left-sidebar' ) ? esc_html_e( 'Skip to second sidebar', 'dw-mekatron' ) : esc_html_e( 'Skip to sidebar', 'dw-mekatron' ); ?></a>

	<?php endif; ?>

</nav> <!-- /skip -->

<div id="site-wrapper" class="site-wrapper">

		<!-- ? HEADER SECTION STARTS -->
		<header>
			<div class="hd-body">
				<div class="hd-row1">
					<div class="hd-row1-inner1"></div>
					<div class="hd-row1-inner2"></div>
				</div>
				<div class="hd-row2">
					<div class="hd-row2-inner">
						<div class="row2-centerline">
							<div class="row2-center">
								<div class="row2-center-inner">
									<div id="headerlogo">
										<a href="<?php echo esc_url( home_url() ); ?>">
										<?php
										$dw_mekatron_custom_logo_id = get_theme_mod( 'custom_logo' );
										$dw_mekatron_logo           = wp_get_attachment_image_src( $dw_mekatron_custom_logo_id, 'full' );
					
										if ( has_custom_logo() ) {
											echo '<img src="' . esc_url( $dw_mekatron_logo[0] ) . '" alt="' . esc_html( get_bloginfo( 'name' ) ) . '">';
										} else {
											echo '<div id="blog-name">' . esc_html( get_bloginfo( 'name' ) ) . '</div>';
											echo '<div id="blog-tagline">' . esc_html( get_bloginfo( 'description' ) ) . '</div>';
										}
										?>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="hd-row3">
					<div class="hd-row3-inner1"></div>
					<div class="hd-row3-inner2"></div>
				</div>
				<div class="hd-row4">
					<div class="hd-row4-inner1">
					<div class="datetime">
						<div id="dw-mekatron-digital-clock">
							<span class="date-string"><?php esc_html_e( 'Date:', 'dw-mekatron' ); ?></span>
							<span class="date-date"></span>
							<span class="time-string"><?php esc_html_e( 'Time:', 'dw-mekatron' ); ?></span>
							<span class="time-time"></span>
						</div>
					</div>
					</div>
					<div class="hd-row4-inner2"></div>
					<div class="hd-row4-inner3"></div>
					<div class="hd-row4-inner4">
					<div class="userlog">
						<?php 
						if ( is_user_logged_in() ) {
							/* translators: %s = Logout URL */
							$dw_mekatron_html_message = sprintf( __( 'Welcome, you are logged in. <a href="%s">Logout?</a>', 'dw-mekatron' ), esc_url( wp_login_url() ) );
							echo wp_kses_post( $dw_mekatron_html_message );
						} else {
							/* translators: %s = Login URL */
							$dw_mekatron_html_message = sprintf( __( 'Welcome, Log in by clicking <a href="%s">&nbsp;Here!</a>', 'dw-mekatron' ), esc_url( wp_login_url() ) );
							echo wp_kses_post( $dw_mekatron_html_message );
						} 
						?>
						</div>
					</div>
				</div>
				<div class="hd-row5">
					<div class="hd-row5-inner1"></div>
					<div class="hd-row5-inner2">
						<div class="row5-centerline">
							<div class="row5-center">
								<div class="row5-center-inner">
									<a class="row5-center-nav-link-1" href="<?php echo esc_url( get_theme_mod( 'dw-mekatron-hnav-link1' ) ); ?>"><div class="hdmainnav"><?php echo esc_textarea( get_theme_mod( 'dw-mekatron-hnav-linkname1' ) ); ?></div></a>
									<a class="row5-center-nav-link-2" href="<?php echo esc_url( get_theme_mod( 'dw-mekatron-hnav-link2' ) ); ?>"><div class="hdmainnav"><?php echo esc_textarea( get_theme_mod( 'dw-mekatron-hnav-linkname2' ) ); ?></div></a>
									<a class="row5-center-nav-link-3" href="<?php echo esc_url( get_theme_mod( 'dw-mekatron-hnav-link3' ) ); ?>"><div class="hdmainnav"><?php echo esc_textarea( get_theme_mod( 'dw-mekatron-hnav-linkname3' ) ); ?></div></a>
									<a class="row5-center-nav-link-4" href="<?php echo esc_url( get_theme_mod( 'dw-mekatron-hnav-link4' ) ); ?>"><div class="hdmainnav"><?php echo esc_textarea( get_theme_mod( 'dw-mekatron-hnav-linkname4' ) ); ?></div></a>
									<a class="row5-center-nav-link-5" href="<?php echo esc_url( get_theme_mod( 'dw-mekatron-hnav-link5' ) ); ?>"><div class="hdmainnav"><?php echo esc_textarea( get_theme_mod( 'dw-mekatron-hnav-linkname5' ) ); ?></div></a>
								</div>
							</div>
						</div>
					</div>
					<div class="hd-row5-inner3">
						<!--- Start Social Bar --->

						<div id="socialbar">
								<?php if ( get_theme_mod( 'dw_mekatron_display_socialicons' ) !== '' ) { ?>
									<div class="socialicon-wrap">
										<?php if ( get_theme_mod( 'dw_mekatron_facebook_url' ) !== '' ) { ?>
											<a href="<?php echo esc_url( get_theme_mod( 'dw_mekatron_facebook_url', '' ) ); ?>"><div class="socialicon-fb"></div></a>
										<?php } ?>
										<?php if ( get_theme_mod( 'dw_mekatron_gplus_url' ) !== '' ) { ?>
											<a href="<?php echo esc_url( get_theme_mod( 'dw_mekatron_gplus_url', '' ) ); ?>"><div class="socialicon-gplus"></div></a>
										<?php } ?>
									</div>
								<?php } ?>
						</div>

						<!-- End Social Bar -->
					</div>
				</div>
				<div class="hd-row6">
					<div class="hd-row6-inner">
						<div class="hmenu2">

							<nav id="site-navigation2" class="main-navigation2" role="navigation2">
							<?php
								wp_nav_menu(
									array(
										'theme_location'       => 'top_header_menu',
										'menu_id'              => 'header-menu-content',
										'fallback_cb'          => false,
										'container'            => 'nav',
										'container_id'         => 'header-menu',
										'container_aria_label' => _x( 'Header Menu', 'ARIA label', 'dw-mekatron' ),
									)
								);
								?>
								</nav><!-- #site-navigation -->

						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- ! HEADER SECTION ENDS -->

<div id="sb-wrap">

<div id="headerlogo2">
	<a href="<?php echo esc_url( home_url() ); ?>">
	<?php
	$dw_mekatron_custom_logo_id = get_theme_mod( 'custom_logo' );
	$dw_mekatron_logo           = wp_get_attachment_image_src( $dw_mekatron_custom_logo_id, 'full' );
					
	if ( has_custom_logo() ) {
		echo '<img src="' . esc_url( $dw_mekatron_logo[0] ) . '" alt="' . esc_html( get_bloginfo( 'name' ) ) . '">';
	} else {
		echo '<div id="blog-name">' . esc_html( get_bloginfo( 'name' ) ) . '</div>';
		echo '<div id="blog-tagline">' . esc_html( get_bloginfo( 'description' ) ) . '</div>';
	}
	?>
	</a>
</div> <!-- /header -->

<div class="hmenu">

<nav id="site-navigation" class="main-navigation" role="navigation">
	<button class="menu-toggle"><?php esc_html_e( 'Menu', 'dw-mekatron' ); ?></button>
		<?php
			wp_nav_menu(
				array(
					'theme_location'       => 'top_header_menu',
					'menu_class'           => 'nav-menu',
					'container_aria_label' => _x( 'Header Menu', 'ARIA label', 'dw-mekatron' ),
				)
			);
			?>
</nav><!-- #site-navigation -->

</div>

<!-- ? MAIN STARTS -->
<main id="main-container" class="main-container">

<?php
if ( is_active_sidebar( 'left-sidebar' ) ) : 

	?>

<div id="widget-left" class="widget-column">

<!-- ? LEFT WIDGET AREA STARTS -->

	<?php if ( is_active_sidebar( 'left-sidebar' ) ) : ?>	
		<!-- SB 1 -->		
		<div class="widget-container">
			<div class="blk-body">
				<div class="blk-row1">
					<div class="blk-row1-inner"></div>
				</div>
				<div class="blk-content">
					<div class="blk-content-inner">
						<aside role="complementary" id="left" class="sidebar" aria-label="<?php echo is_active_sidebar( 'right-sidebar' ) ? esc_attr_x( 'Left Sidebar 1', 'ARIA label', 'dw-mekatron' ) : esc_attr_x( 'Sidebar', 'ARIA label', 'dw-mekatron' ); ?>">
							<ul>
							<?php dynamic_sidebar( 'left-sidebar' ); ?>
							</ul>
						</aside>
					</div>
				</div>
				<div class="blk-row3">
					<div class="blk-row3-inner"></div>
				</div>
			</div>
		</div>
		<!-- END SB 1 -->
	<?php endif; ?>

	</div> <!--- END WIDGET COLUMN --->

<?php endif; ?>

<div id="content">
