<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package BlogX
 */
$blog_x_categories_list = get_the_category_list(esc_html__(', ', 'blog-x'));
$blog_x_posts_meta = get_theme_mod('blog_x_posts_meta', '1');
$blog_x_post_btntext = get_theme_mod('blog_x_post_btntext', esc_html__('Read More', 'blog-x'));

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('list-art'); ?>>
	<?php if (has_post_thumbnail()) : ?>
		<div class="content-list">
			<div class="list-img">

				<div class="baby-feature-image">
					<a href="<?php the_permalink(); ?>">
						<?php the_post_thumbnail(); ?>
					</a>
				</div>
			</div>

		<?php else : ?>
			<div class="content-list noimg">

			<?php endif; ?>
			<div class="list-content">
				<header class="entry-header">
					<?php

					the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');

					if ('post' === get_post_type() && $blog_x_posts_meta == 1) : ?>

						<div class="entry-meta post-meta list-meta">
							<?php blog_x_posted_on(); ?>
						</div><!-- .entry-meta -->
					<?php
					endif; ?>
				</header><!-- .entry-header -->
				<div class="entry-content">
					<?php
					the_excerpt(); ?>
					<div class="redmore-btn"> <a href="<?php the_permalink(); ?>" class="more-link" rel="bookmark"> <?php echo esc_html($blog_x_post_btntext); ?></a></div>
				</div><!-- .entry-content -->
			</div>
			</div>





</article><!-- #post-<?php the_ID(); ?> -->