<?php

/**
 * Blogx Theme Customizer
 *
 * @package Blogx
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
// adctive call back function for header slider
if (!function_exists('blog_x_blank_image_show')) :
    function blog_x_blank_image_show()
    {
        if (get_theme_mod('blog_x_posts_image') == '1') {
            return true;
        } else {
            return false;
        }
    }
endif;
// adctive call back function for header slider
if (!function_exists('blog_x_image_height')) :
    function blog_x_image_height()
    {
        if (get_theme_mod('blog_x_posts_image') == '1' &&  get_theme_mod('blog_x_posts_blank_image') == '1') {
            return true;
        } else {
            return false;
        }
    }
endif;



function blog_x_customize_register($wp_customize)
{

    $wp_customize->remove_control('xblog_content_type_control');
    $wp_customize->remove_control('xblog_header_search_control');
    $wp_customize->remove_control('footer_copywright');

    $wp_customize->add_setting('blog_x_posts_meta', array(
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'default'       =>  '1',
        'sanitize_callback' => 'absint',
        'transport'     => 'refresh',
    ));
    $wp_customize->add_control('blog_x_posts_meta_control', array(
        'label'      => __('Show post meta? ', 'blog-x'),
        'description' => __('You can show or hide posts meta.', 'blog-x'),
        'section'    => 'x_blog_options',
        'settings'   => 'blog_x_posts_meta',
        'type'       => 'checkbox',

    ));
    $wp_customize->add_setting('blog_x_post_btntext', array(
        'default'        => __('Read More', 'blog-x'),
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'refresh',
        'priority'       => 15,
    ));
    $wp_customize->add_control('blog_x_post_btntext', array(
        'label'      => __('Posts Read More Text', 'blog-x'),
        'description'     => __('You can change post button read more text', 'blog-x'),
        'section'    => 'x_blog_options',
        'settings'   => 'blog_x_post_btntext',
        'type'       => 'text',

    ));
}
add_action('customize_register', 'blog_x_customize_register', 99);
