<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package BlogX
 */
$blog_x_theme_layout = get_theme_mod('theme_layout');
$blog_x_logo_position = get_theme_mod('logo_position', 'logo-center');
$blog_x_menu_position = get_theme_mod('menu_position', 'center');
$blog_x_slider_text = get_theme_mod('slider_text');
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php
	if (function_exists('wp_body_open')) {
		wp_body_open();
	}
	?>
	<?php do_action('blog_x_mobile_menu'); ?>
	<div id="page" class="site x-blog">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'blog-x'); ?></a>
		<header id="masthead" class="site-header baby-head-img">
			<?php if (has_header_image()) : ?>
				<div class="header-img">
					<?php the_header_image_tag(); ?>
				</div>
			<?php else : ?>
				<div class="no-header-img">

				<?php endif; ?>
				<div class="baby-container site-branding <?php echo esc_attr($blog_x_logo_position); ?>">
					<?php
					if (has_custom_logo()) :
						the_custom_logo();
					endif;
					?>
					<h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
					<?php

					$description = get_bloginfo('description', 'display');
					if ($description || is_customize_preview()) : ?>
						<p class="site-description"><?php echo esc_html($description); ?></p>
					<?php
					endif; ?>
				</div><!-- .site-branding -->
				<?php do_action('xblog_main_menubar'); ?>


		</header><!-- #masthead -->

		<?php if (!empty($blog_x_slider_text) && is_home()) : ?>
			<section class="home-feature-slider">
				<?php echo wp_kses_post(do_shortcode($blog_x_slider_text)); ?>
			</section>
		<?php endif; ?>

		<div id="content" class="baby-container site-content <?php echo esc_attr($blog_x_theme_layout); ?>">
			<div class="content-row">