<?php
/*This file is part of X blog child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/

if (!defined('BLOGX_VERSION')) {
	// Replace the version number of the theme on each release.
	define('BLOGX_VERSION', '1.0.4');
}



function blog_x_fonts_url()
{
	$fonts_url = '';

	$font_families = array();

	$font_families[] = 'Lora:300,400,500,700';
	$font_families[] = 'Merriweather:400,500,500i,700,700i';

	$query_args = array(
		'family' => urlencode(implode('|', $font_families)),
		'subset' => urlencode('latin,latin-ext'),
	);

	$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');


	return esc_url_raw($fonts_url);
}


function blog_x_enqueue_child_styles()
{
	wp_enqueue_style('blogx-google-font', blog_x_fonts_url(), array(), null);
	wp_enqueue_style('blogx-parent-style', get_template_directory_uri() . '/style.css', array('slicknav', 'xblog-google-font', 'xblog-style'), '', 'all');
	wp_enqueue_style('blogx-main', get_stylesheet_directory_uri() . '/assets/css/main.css', array(), BLOGX_VERSION, 'all');

	wp_enqueue_script('blogx-mobile-menu', get_stylesheet_directory_uri() . '/assets/js/mobile-menu.js', array('jquery'), BLOGX_VERSION, true);
	wp_enqueue_script('blogx-main-js', get_stylesheet_directory_uri() . '/assets/js/xmain.js', array('jquery'), BLOGX_VERSION, true);
}
add_action('wp_enqueue_scripts', 'blog_x_enqueue_child_styles');



if (!function_exists('blog_x_posted_on')) :
	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 */
	function blog_x_posted_on()
	{
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if (get_the_time('U') !== get_the_modified_time('U')) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time> | <time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr(get_the_date('c')),
			esc_html(get_the_date()),
			esc_attr(get_the_modified_date('c')),
			esc_html(get_the_modified_date())
		);

		$posted_on = sprintf(
			/* translators: %s: post date. */
			esc_html_x('- %s', 'post date', 'blog-x'),
			'<a href="' . esc_url(get_permalink()) . '" rel="bookmark">' . $time_string . '</a>'
		);

		$byline = sprintf(
			/* translators: %s: post author. */
			esc_html_x('- %s', 'post author', 'blog-x'),
			'<span class="author vcard"><a class="url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a></span>'
		);

		echo '<span class="posted-on"><i class="fa fa-clock-o"></i>' . wp_kses_post($posted_on) . '</span><span class="byline"> <i class="fa fa-user-circle"></i>' . wp_kses_post($byline) . '</span>';
	}
endif;

/**
 * Customizer additions.
 */
require get_stylesheet_directory() . '/inc/customizer.php';



if (!function_exists('blog_x_inline_css')) :
	function blog_x_inline_css()
	{
		$blog_x_grid_height = get_theme_mod('blog_x_grid_height', 750);
		$blog_x_posts_image = get_theme_mod('blog_x_posts_image', '1');
		$blog_x_posts_blank_image = get_theme_mod('blog_x_posts_blank_image', '1');
		$style = '';
		if ($blog_x_posts_image == '1' && $blog_x_posts_blank_image == '1') {
			if ($blog_x_grid_height != 750) {
				$style .= '.site-main article.xgrid-item{min-height:' . esc_attr($blog_x_grid_height) . 'px}';
			}
		}
		if ($blog_x_posts_image != '1') {
			$style .= '.site-main article.xgrid-item{min-height:auto;padding-bottom:30px;}';
		}


		wp_add_inline_style('blogx-main', $style);
	}
	add_action('wp_enqueue_scripts', 'blog_x_inline_css');
endif;


function blog_x_excerpt_length($length)
{
	if (is_admin()) return $length;
	return 30;
}
add_filter('excerpt_length', 'blog_x_excerpt_length', 999);

function blog_x_excerpt_more($more)
{
	if (is_admin()) return $more;
	return ' ...';
}
add_filter('excerpt_more', 'blog_x_excerpt_more');



/**
 * Calculate and return estimated reading time for a post
 */
if (!function_exists('blog_x_reading_time')) :
	function blog_x_reading_time()
	{
		$content = get_post_field('post_content', get_the_ID());
		$word_count = str_word_count(strip_tags($content));
		$reading_time = ceil($word_count / 200); // Assuming average reading speed of 200 words per minute

		if ($reading_time == 1) {
			$reading_time_text = sprintf(
				/* translators: %d: Reading time in minutes */
				esc_html__('%d minute read', 'blog-x'),
				$reading_time
			);
		} else {
			$reading_time_text = sprintf(
				/* translators: %d: Reading time in minutes */
				esc_html__('%d minutes read', 'blog-x'),
				$reading_time
			);
		}

		return '<span class="reading-time"><i class="fa fa-book"></i> ' . $reading_time_text . '</span>';
	}
endif;

/**
 * Customizer additions.
 */
require_once get_stylesheet_directory() . '/inc/mobile-menu.php';
